package parser;

/**
 * Factory for E1 grammar non-terminal objects.
 */
public class E1Fact extends ATVFactory {
    /**
     * Factory for E1a grammar non-terminals.
     */
    private E1aFact _e1aFac;

    /**
     * Factory for Empty grammar terminals.
     */
    private EmptyFact _emptyFac;

    /**
     * Constructor for the E1 factory,
     *
     * @param tkz       tokenizer to use
     * @param e1aFact   factory for E1a non-terminals
     * @param emptyFact factory for empty terminals
     */
    public E1Fact(ITokenizer tkz, E1aFact e1aFact, EmptyFact emptyFact) {
        super(tkz);
        _e1aFac = e1aFact;
        _emptyFac = emptyFact;

    }

    /**
     * Make a token visitor to parse an E1 non-terminal.
     *
     * @return token visitor
     */
    public ITokVisitor makeVisitor() {
        return _e1aFac.makeChainedVisitor(_emptyFac.makeVisitor());
    }

    /**
     * Make a token visitor that delegates to the given visitor in a chain of responsibility
     *
     * @param successor visitor to serve as successor in the chain
     */
    public ITokVisitor makeChainedVisitor(ITokVisitor successor) {
        return _e1aFac.makeChainedVisitor(_emptyFac.makeChainedVisitor(successor));
    }
}

