package lrs.visitor;
import lrs.*;
import lrs.visitor.fold.*;
import fp.*;

/**
 * Find and return the list whose first is the minimum element.
 * @author DXN
 * @since 09/27/04
 */
public class MinLRS implements IAlgo {
    public static final MinLRS Singleton = new MinLRS();
    private MinLRS() {
    };
    
    public Object emptyCase(LRStruct host, Object inp){
        return host;
    }
    
    public Object nonEmptyCase(final LRStruct host, Object inp){
        return host.getRest().execute(new IAlgo() {
            public Object emptyCase(LRStruct h, Object acc){
                return acc;
            }
            public Object nonEmptyCase(LRStruct h, Object acc){
                return h.getRest().execute(this, Min2LRS.Singleton.apply(h, acc));
              // can also do by comparing firsts right here rather than calling Min2LRS
            }
        }, host);
    }
}

