package lrs.visitor.fold;

import lrs.*;
import fp.*;

/**
 * Returns the minimum of 2 trees.
 * @author DXN
 */
public class Min2LRS implements ILambda {
    public static final Min2LRS Singleton = new Min2LRS();
    private Min2LRS() {
    };
    
    private static IAlgo min = new IAlgo() {
        public Object emptyCase(LRStruct host, Object inp) {
            return inp;
        }
        
        public Object nonEmptyCase(LRStruct host, Object inp) {
            LRStruct temp = (LRStruct)inp;
            return (Integer)host.getFirst() < (Integer)temp.getFirst()? host: temp;
        }
    };
    
    public Object apply(Object... args) {
        return ((LRStruct)args[0]).execute(min, args[1]);
    }
}