package lrs.test;

import junit.framework.TestCase;
import lrs.*;
import lrs.visitor.*;
import lrs.visitor.fold.*;


/**
 */
public class Test_FoldlMinList extends TestCase {
    private static IAlgo m = new FoldlLRS(Min2LRS.Singleton);
    
    /**
     */
    public void testEmpty() {
        LRStruct lrs = new LRStruct();
        assertEquals("Foldl Min LRS:", lrs, lrs.execute(m, lrs));
    }
    
    /**
     */
    public void testNonEmpty() {
        LRStruct lrs = new LRStruct();        
        lrs.insertFront(5);
        Object minLRS = lrs.execute(m, lrs);
        System.out.println(lrs + "\nFoldlLRS Min LRS is:\n"+ minLRS + '\n');        
        assertEquals("FoldlLRS Min LRS for non-empty tree:", lrs, minLRS);

        lrs.getRest().insertFront(-2);
        minLRS = lrs.execute(m, lrs);
        System.out.println(lrs + "\nFoldlLRS Min LRS is:\n"+ minLRS + '\n');        
        assertEquals("FoldlLRS Min LRS for non-empty tree:", lrs.getRest(), minLRS);

        lrs.getRest().insertFront(10);
        minLRS = lrs.execute(m, lrs);
        System.out.println(lrs + "\nFoldlLRS Min LRS is:\n"+ minLRS + '\n');        
        assertEquals("FoldlLRS Min LRS for non-empty tree:", lrs.getRest().getRest(), minLRS);

        lrs.getRest().getRest().insertFront(-9);
        minLRS = lrs.execute(m, lrs);
        System.out.println(lrs + "\nFoldlLRS Min LRS is:\n"+ minLRS + '\n');        
        assertEquals("FoldlLRS Min LRS for non-empty tree:", lrs.getRest().getRest(), minLRS);    }
}
