package lrs.visitor.test;

import lrs.*;
import lrs.visitor.*;
import lrs.visitor.map.*;

import junit.framework.TestCase;

public class Test_MapLRS extends TestCase {

  private LRStruct makeLRS(Object ... p) {
    LRStruct result = new LRStruct();
    for(int i = p.length-1; i >=0; i--) {
      result.insertFront(p[i]);
    }
    return result;
  }
  
  public void test_Square() {
    LRStruct list = makeLRS();
    IAlgo map = new MapLRS(Square.Singleton);
    assertEquals("empty list", "()", list.execute(map, null).toString());
    list = makeLRS(3);
    assertEquals("1-elt list", "(9)", list.execute(map, null).toString());
    list = makeLRS(5, 7);
    assertEquals("2-elt list", "(25 49)", list.execute(map, null).toString());   
  }
  
  public void test_AppendStr() {
    LRStruct list = makeLRS();
    IAlgo map = new MapLRS(AppendStr.Singleton);
    String str = "?";
    assertEquals("empty list", "()", list.execute(map, str).toString());
    list = makeLRS("why");
    assertEquals("1-elt list", "(why?)", list.execute(map, str).toString());
    list = makeLRS("how", "why");
    assertEquals("2-elt list", "(how? why?)", list.execute(map, str).toString());  
  }
  
  public void test_AbsVal() {
    LRStruct list = makeLRS();
    IAlgo map = new MapLRS(AbsVal.Singleton);
    assertEquals("empty list", "()", list.execute(map, null).toString());
    list = makeLRS(3);
    assertEquals("1-elt list", "(3)", list.execute(map, null).toString());
    list = makeLRS(-3);
    assertEquals("1-elt list", "(3)", list.execute(map, null).toString());
    list = makeLRS(-5, 6);
    assertEquals("2-elt list", "(5 6)", list.execute(map, null).toString());  
    list = makeLRS(-5, -6);
    assertEquals("2-elt list", "(5 6)", list.execute(map, null).toString());  
  }
  
  public void test_ReplaceStr() {
    LRStruct list = makeLRS();
    IAlgo map = new MapLRS(new ReplaceStr("stop"));
    String str =  "replaced";
    assertEquals("empty list", "()", list.execute(map, str).toString());
    list = makeLRS("yes");
    assertEquals("1-elt list", "(replaced)", list.execute(map, str).toString());
    list = makeLRS("stop");
    assertEquals("1-elt list", "(stop)", list.execute(map, str).toString());
    list = makeLRS("abc", "def");
    assertEquals("2-elt list", "(replaced replaced)", list.execute(map, str).toString());  
    list = makeLRS("abc", "stop");
    assertEquals("2-elt list", "(replaced stop)", list.execute(map, str).toString());  
    list = makeLRS("stop", "def");
    assertEquals("2-elt list", "(stop def)", list.execute(map, str).toString());  
  }
   
}
