
package brs.visitor;
import brs.*;
import brs.visitor.traverse.*;

/**
 * Find and return the tree containing the minimum element.
 * Throw an exception when the tree is empty.
 * @author Dung X. Nguyen - Copyright 2004 - All rights reserved.
 */
public class GetMinTree implements IVisitor {
    
    private IVisitor MinTreeHelp = new IVisitor() {
        public  Object emptyCase(BiTree host, Object inp) {
            return inp;
        }
        
        public Object nonEmptyCase(BiTree host, Object inp) {
            BiTree acc = (BiTree)inp;
            BiTree temp = (BiTree)host.execute(GetMinTree.this, null);
            return (Integer)temp.getRootDat() < (Integer)acc.getRootDat()? temp: acc;
        }
    };
    
    /**
    */
    public  Object emptyCase(BiTree host, Object inp) {
        throw new java.util.NoSuchElementException("Empty Tree has no minimum.");
    }

    /**
    */
    public Object nonEmptyCase(BiTree host, Object inp) {
        BiTree temp = (BiTree)host.getLeftSubTree().execute(MinTreeHelp, host);
        temp = (Integer)temp.getRootDat() < (Integer)host.getRootDat()? temp: host;
        return host.getRightSubTree().execute(MinTreeHelp, temp);
    }

    public static void main(String[] nu) {        
        BiTree bt = new BiTree();
        
        bt.insertRoot(5);
        System.out.println(bt + "\nMin Tree is:\n"+ bt.execute(new GetMinTree(), null) + '\n');        
        bt.getLeftSubTree().insertRoot(-2);
        System.out.println(bt + "\nMin Tree is:\n"+ bt.execute(new GetMinTree(), null) + '\n');        
        bt.getRightSubTree().insertRoot(10);        
        System.out.println(bt + "\nMin Tree is:\n"+ bt.execute(new GetMinTree(), null) + '\n');        
        bt.getRightSubTree().getLeftSubTree().insertRoot(-9);        
        System.out.println(bt + "\nMin Tree is:\n"+ bt.execute(new GetMinTree(), null) + '\n');        
        System.out.println("Done!");        
    }
}

