
package brs.visitor;
import brs.*;
import brs.visitor.traverse.*;

import fp.*;


/**
 * Find and return the tree containing the minimum element.
 * If the tree is empty, return the tree itself
 * @author Dung X. Nguyen - Copyright 2004 - All rights reserved.
 */
public class MinTree implements IVisitor {
    public static final MinTree Singleton = new MinTree();
    
    private MinTree() {}
    
    private IVisitor LeftTreeHelp = new IVisitor() {
        public  Object emptyCase(BiTree host, Object inp) {
            return inp;
        }
        
        public Object nonEmptyCase(BiTree host, Object inp) {
            return host;
        }
    };
    
    private IVisitor RightTreeHelp = new IVisitor() {
        public  Object emptyCase(BiTree host, Object inp) {
            return inp;
        }
        
        public Object nonEmptyCase(BiTree host, Object inp) {
            BiTree temp = (BiTree)inp;
            return (Integer)host.getRootDat() < (Integer)temp.getRootDat()? host: temp;
        }
    };

    /**
    */
    public  Object emptyCase(BiTree host, Object inp) {
        return host;
    }

    /**
    */
    public Object nonEmptyCase(BiTree host, Object inp) {
        BiTree minLeft = (BiTree)host.getLeftSubTree().execute(this, null);
        BiTree temp = (BiTree)minLeft.execute(LeftTreeHelp, host);
        BiTree minRight = (BiTree)host.getRightSubTree().execute(this, null);
        return minRight.execute(RightTreeHelp, temp);
    }

}

