
package counter;
import logic.*;

/**
 * @dependency EqualsZero uses
 */
class NonZeroState extends ACounterState
 implements ILogicAlgo
{
 private int count;
 /**
  * @param count 
  */
 NonZeroState(int count)
 {
  this.count = count;

 }



 /**
  * @param host 
  */
 Counter decrement(Counter host)
 {
  EqualsZero.Singleton.isTrue(new Integer(--count)).execute(this, host);
  return(host);
 }

 /**
  * @param host
  */
 Counter increment(Counter host)
 {
  EqualsZero.Singleton.isTrue(new Integer(++count)).execute(this, host);
  return(host);
 }

 /**
  * @param host 
  */
 int getCount(Counter host)
 {
  return(count);
 }

 /**
  * @param host 
  * @param count 
  */
 void setCount(Counter host, int count)
 {
  this.count = count;
  EqualsZero.Singleton.isTrue(new Integer(count)).execute(this, host);
 }

 /**
  * @param host 
  * @param algo 
  * @param param 
  */
 Object execute(Counter host, ICounterAlgo algo, Object param)
 {
  return(algo.nonZeroCase(host, param));
 }

 /**
  * @param host 
  * @param param 
  * @return 
  */
 public Object trueCase(ILogical host, Object param)
 {
  ((Counter) param).setCounterState(ZeroState.Singleton);
  return (null); 
 }

 /**
  * @param host 
  * @param param 
  * @return 
  */
 public Object falseCase(ILogical host, Object param)
 {
  return (null);  
 }
}

