package calc;

public class Operator implements Token {

    // constants
    public static final int PLUS = 0;
    public static final int MINUS = 1;
    public static final int MULT = 2;
    public static final int DIV = 3;

    // fields
    private int _type;

    public Operator(int type) {
	_type = type;
    }

    public int getType() {
	return _type;
    }

    public Object execute(TokenVisitor viz, Object input)
	throws CalcException {
	return viz.handleOperator(this, input);
    }

    public Double evaluate(Double v1, Double v2) 
	throws DivideByZeroException {
	double d1 = v1.doubleValue();
	double d2 = v2.doubleValue();
	double result;

	switch(_type) {
	case PLUS:
	    result = d1 + d2;
	    break;
	case MINUS:
	    result = d1 - d2;
	    break;
	case MULT:
	    result = d1 * d2;
	    break;
	case DIV:
	    if(d2 == 0) {
		throw new DivideByZeroException("" + d1 + ", " + d2);
	    }

	    result = d1 / d2;
	    break;
	default:
	    throw new RuntimeException("Unsupported operation!");
	}

	return new Double(result);
    }
}
