package calc;

public class CalcParser {
  
  public static Expression parseExpression(CalcTokenizer ct) 
    throws CalcException {
    
    Number n1 = null;
    Number n2 = null;
    Operator op = null;
    
    // parse a number
    n1 = parseNumber(ct);
    op = parseOperator(ct);
    n2 = parseNumber(ct);
    parseEol(ct);
    
    return new Expression(n1, op, n2);
  }
  
  public static Number parseNumber(CalcTokenizer ct) throws CalcException {
    return (Number) ct.getNextToken().execute(new TokenVisitor() {
      public Object handleNumber(Number n, Object input) {
        return n;
      }
      
      public Object handleOperator(Operator o, Object input)
        throws CalcException {
        throw new CalcException("Number was expected, " +
                                "found operand");
      }
      
      public Object handleEol(Eol e, Object input)
        throws CalcException {
        throw new CalcException("Number was expected, " +
                                "found EOL");
      }
    }, null);
  }
  
  public static Operator parseOperator(CalcTokenizer ct) 
    throws CalcException {
    return (Operator) ct.getNextToken().execute(new TokenVisitor() {
      public Object handleNumber(Number n, Object input) 
        throws CalcException {
        throw new CalcException("Operator was expected, " +
                                "found number");
      }
      
      public Object handleOperator(Operator o, Object input) {
        return o;
      }
      
      public Object handleEol(Eol e, Object input)
        throws CalcException {
        throw new CalcException("Operator was expected, " +
                                "found EOL");
      }
    }, null);
  }
  
  public static Eol parseEol(CalcTokenizer ct) 
    throws CalcException {
    return (Eol) ct.getNextToken().execute(new TokenVisitor() {
      public Object handleNumber(Number n, Object input) 
        throws CalcException {
        throw new CalcException("EOL was expected, " +
                                "found number");
      }
      
      public Object handleOperator(Operator o, Object input)
        throws CalcException {
        throw new CalcException("EOL was expected, " +
                                "found operator");
      }
      
      public Object handleEol(Eol e, Object input)
        throws CalcException {
        return e;
      }
    }, null);
  }    
}
