package calc;

import java.io.*;

public class CalcTokenizer {
  
  public static final int PLUS_TOKEN = '+';
  public static final int MINUS_TOKEN = '-';
  public static final int DIV_TOKEN = '/';
  public static final int MULT_TOKEN = '*';
  
  private StreamTokenizer _stok;
  
  public CalcTokenizer(String str) {
    
    // configure the tokenizer
    _stok = new StreamTokenizer(new StringReader(str));
    
    _stok.ordinaryChar(PLUS_TOKEN);
    _stok.ordinaryChar(MINUS_TOKEN);
    _stok.ordinaryChar(DIV_TOKEN);
    _stok.ordinaryChar(MULT_TOKEN);
    
    _stok.parseNumbers();
  }
  
  public Token getNextToken() throws CalcException {
    
    int ttype = -1;
    
    try {
      ttype = _stok.nextToken();
    } catch(IOException ioe) {
      throw new CalcException("IOException generated.");
    }
    
    Token t;
    
    switch(ttype) {
      case StreamTokenizer.TT_NUMBER:
        t = new Number(_stok.nval);
        break;
      case PLUS_TOKEN:
        t = new Operator(Operator.PLUS);
        break;
      case MINUS_TOKEN:
        t = new Operator(Operator.MINUS);
        break;
      case DIV_TOKEN:
        t = new Operator(Operator.DIV);
        break;
      case MULT_TOKEN:
        t = new Operator(Operator.MULT);
        break;
      case StreamTokenizer.TT_EOF:
        t = Eol.SINGLETON;
        break;
      default:
        throw new CalcException("Unrecognized token");
    }
    
    return t;
  }
  
  public void pushBack() {
    _stok.pushBack();
  }
}
