package treeN;
import java.util.*;

/**
 * @dependency treeN.ITreeNAlgo uses
 */
public class TreeN {
    /** @SBGen Collection of treeN.TreeN (,child trees,,64)   */
    private Vector _children = new Vector();
    private Vector _data = new Vector();

    public TreeN() {}

    public TreeN(Integer n) { this(new TreeN(), n, new TreeN());}

    private TreeN(Vector data, Vector children) {
	_data = data; _children = children;
    }

    private TreeN(TreeN lTree, Object n, TreeN rTree) {
	_data.add(n); _children.add(lTree); _children.add(rTree);
    }

    public Integer getDat(int idx) { return (Integer) _data.get(idx); }

    public TreeN getChild(int idx) { return (TreeN) _children.get(idx); }

    /**
   * Splices a source tree into the tree at the supplied child tree index.
   * @param idx -- 0 &lt;= idx &lt;= state of the tree+1, unless state = 0 then idx must equal 0.
   * @param tree -- tree to be spliced in.   If the state of this tree = 0, then nothing is done.
   * @return
   */
    public TreeN spliceAt(int idx, TreeN tree) {
	int i=tree._data.size();
	if(i>0) { // do nothing if tree is empty.
	    if(_data.size() > 0) {
		_children.set(idx, tree.getChild(i--));  // replace the tree @ idx
	    }
	    else { // receiver is empty
		_children.add(idx,tree.getChild(i--));  // idx must = 0
	    }
	    for(; i>=0;i--) {
		_data.add(idx,tree.getDat(i));
		_children.add(idx, tree.getChild(i));
	    }
	}
	return this;
    }

    public TreeN splitUpAt(int idx) {
	if(_data.size()>1) {
	    TreeN lTree, rTree;
	    Vector newData = new Vector(), newChildren = new Vector();
	    Object rootDat = _data.remove(idx);
	    for(int i = 0;i<idx;i++) {
		newData.add(_data.remove(0));
		newChildren.add(_children.remove(0));
	    }
	    newChildren.add(_children.remove(0));
	    if(newData.size()>0) lTree = new TreeN(newData,newChildren);
	    else lTree = (TreeN) newChildren.firstElement();
	    if(_data.size()>0) rTree = new TreeN(_data, _children);
	    else rTree = (TreeN) _children.firstElement();
	    (_data = new Vector()).add(rootDat);
	    (_children = new Vector()).add(lTree);
	    _children.add(rTree);
	}
	return this;
    }

    public TreeN splitDownAt(int idx) {
	if(_data.size()>1){
	  TreeN newChild = new TreeN(getChild(idx),_data.remove(idx),getChild(idx+1));
	  _children.remove(idx);
	  _children.set(idx, newChild);
	}
	else {
	    _data.clear();
	    _children.clear();
	}
	return this;
    }

    public Object execute(ITreeNAlgo algo, Object param) {
	return algo.caseAt(_data.size(), this, param);
    }
}

