package treeNAlgo;
import treeN.*;

public class ToStringAlgo implements ITreeNAlgo {
  private static ToStringAlgo instance = new ToStringAlgo();

  public static ToStringAlgo Singleton() { return instance; }

    private ToStringAlgo() {}

    public Object caseAt(int idx, TreeN host, Object key) {
	   switch(idx) {
	   case 0: {
		    return "[ ]";
	   }
	   default: {
	      String sData= "", sTrees="";
	      for(int i = 0;i<idx;i++) {
		  sData += host.getDat(i)+" ";
		  sTrees += host.getChild(i).execute(toStringHelp,"|  ")+"\n";
	      }
	      sTrees += host.getChild(idx).execute(toStringHelp,"   ").toString();
	      return sData +"\n"+sTrees;
	   }
	   }
    }
    //----------- helper algo --------------------------------------------------
    final private ITreeNAlgo toStringHelp = new ITreeNAlgo() {
	public Object caseAt(int idx, TreeN host, Object prefix) {
	   switch(idx) {
	   case 0: {
			return "|_[ ]";
	   }
	   default: {
		  String sData= "", sTrees="";
		  for(int i = 0;i<idx;i++) {
		      sData += host.getDat(i)+" ";
		      sTrees += prefix
			  + (String) host.getChild(i).execute(this,
							      prefix+"|  ")+"\n";
		  }
		  sTrees += prefix + host.getChild(idx).execute(this,
								prefix+"   "
		      ).toString();
		  return "|_ "+sData +"\n"+sTrees;
	   }
	   }
	}
    };
}
