package listFW;

/**
 * Append another list, passed as input[1], at the end of this list.
 * input[0] must be an IListFactory.
 */
public class Append implements IListAlgo {
  public final static Append Singleton = new Append();
  private Append() { }
  
  /**
   * Returns the input list.
   * @param input input[0] is a list factory, input[1] is the list to append.
   */
  public Object emptyCase(IMTList host, Object... input) {
    return input[1];
  }
  
  /**
   * Returns the appended lists.
   * @param input input[0] is a list factory, input[1] is the list to append.
   */
  public Object nonEmptyCase(INEList host, Object... input) {
    return ((IListFactory)input[0]).makeNEList(host.getFirst(), 
                                               (IList)host.getRest().execute(this, input));
  }
}