package listFW;

/**
 * Folds a list, starting at the left side.
 * @param b[0] is the initial value.
 */
public class FoldL implements IListAlgo {
  private ILambda _f;
  /**
   * Constructor for a FoldL algorithm.
   * @param f a binary ILambda, i.e. one that takes two parameters as varargs.
   */
  public FoldL(ILambda f) {
    _f = f;
  }

  /**
   * Empty case. Return the initial value.
   * @param b b[0] is the initial value.
   * @return initial value
   */
  public Object emptyCase(IMTList h, Object... b) {
    return b[0];
  }
  
  /**
   * Non-empty case. Apply lambda to initial value and first, and recur.
   * @param b b[0] is the initial value.
   * @return result of folding
   */
  public Object nonEmptyCase(INEList h, Object... b) {
    return h.getRest().execute(this, _f.apply(h.getFirst(), b[0]));
  }
  
}