package listFW;

/**
 * Folds a list, starting at the right side.
 * @param b[0] is the initial value.
 */
public class FoldR implements IListAlgo {
  private ILambda _f;
  /**
   * Constructor for a FoldR algorithm.
   * @param f a binary ILambda, i.e. one that takes two parameters as varargs.
   */
  public FoldR(ILambda f) {
    _f = f;
  }

  /**
   * Empty case. Return the initial value.
   * @param b b[0] is the initial value.
   * @return initial value
   */
  public Object emptyCase(IMTList h, Object... b) {
    return b[0];
  }
  
  /**
   * Non-empty case. Apply lambda to initial value and first, and recur.
   * @param b b[0] is the initial value.
   * @return result of folding
   */
  public Object nonEmptyCase(INEList h, Object... b) {
    return _f.apply(h.getFirst(), h.getRest().execute(this, b));
  }
  
}