package listFW;

/**
 * Reverses a list. The first of the varargs (input[0]) needs to be an IListFactory.
 */
public class Reverse implements IListAlgo {
  // singleton pattern
  public final static Reverse Singleton = new Reverse();
  private Reverse() { }
  
  /**
   * Returns the empty list.
   * @param input input[0] is a list factory
   */
  public Object emptyCase(IMTList host, Object... input) {
    return host;
  }
  
  /**
   * Returns the reversed list.
   * @param input input[0] is a list factory
   */
  public Object nonEmptyCase(INEList host, Object... input) {
    // use a helper to do forward accumulation
    // initial value is the empty list
    return host.execute(new IListAlgo() {
      public Object emptyCase(IMTList host, Object... input) {
        // return the accumulator
        return input[1];
      }
      public Object nonEmptyCase(INEList host, Object... input) {
        // create a new NEList out of the first and the accumulator, then recur
        return host.getRest().execute(this,
                                      input[0], 
                                      ((IListFactory)input[0]).makeNEList(host.getFirst(), 
                                                                          (IList)input[1]));        
      }
    }, input[0], ((IListFactory)input[0]).makeEmptyList());
  }
}