package listFW;

/**
 * Computes a String reprsentation of IList showing  a left parenthesis followed
 * by elements of the IList separated by commas, ending with with a right parenthesis.
 * @stereotype visitor
 * @author D.X. Nguyen
 * @since 02/27/2004
 */
public class ToStringAlgo implements IListAlgo {
  // singleton pattern
  public static final ToStringAlgo Singleton = new ToStringAlgo();
  private ToStringAlgo() {
  }
  
  /**
   * Returns "()".
   */
  public Object emptyCase(IMTList host, Object... inp) {
    return "()";
  }
  
  /**
   * Passes "(" + first to the rest of IList and asks for help to complete the computation.
   */
  public Object nonEmptyCase(INEList host, Object... inp) {
    return host.getRest().execute(ToStringHelper.Singleton, "(" + host.getFirst());
  }
}

/**
 * Helps ToStringAlgo compute the String representation of the rest of the list.
 */
class ToStringHelper implements IListAlgo {
  public static final ToStringHelper Singleton = new ToStringHelper();
  private ToStringHelper() {
  }
  
  /**
   * Returns the accumulated String + ")".
   * At end of list: done!  
   */
  public Object emptyCase(IMTList host, Object... acc) {
    return  acc[0] + ")";
  }
  
  /**
   * Continues accumulating the String representation by appending ", " + first to acc
   * and recur!
   */
  public Object nonEmptyCase(INEList host, Object... acc) {
    return host.getRest().execute(this, acc[0] + ", " + host.getFirst());
  }
}

