package listFW.test;

import junit.framework.TestCase;

import listFW.*;
import listFW.factory.*;

/**
 * Testing appending a list.
 * @author DXN
 */
public class TestAppend extends TestCase {
  final IListFactory fac = CompositeListFactory.Singleton;    
  IList mt = fac.makeEmptyList();
  IList ne1 = fac.makeNEList("1", fac.makeNEList("2", fac.makeNEList("3", mt)));
  IList ne2 = fac.makeNEList("a", fac.makeNEList("b", mt));
  
  // same f as in TestReverse!
  ILambda f = new ILambda() {
    public Object apply(Object... params) {
      return fac.makeNEList(params[0], (IList)params[1]);
    }
  };
  
  // but we fold in a different direction, and use a different initial value
  IListAlgo algo = new FoldR(f);

  public void testFoldEmpty() {
    assertEquals("Append Empty/Empty list", "()", mt.execute(algo, mt).toString());
  }
  
  public void testFoldEmptyNE() {
    assertEquals("Append Empty/NE list", "(1, 2, 3)", mt.execute(algo, ne1).toString());
  }

  public void testFoldNEEmpty() {
    assertEquals("Append NE/Empty list", "(a, b)", ne2.execute(algo, mt).toString());
  }
  
  public void testFoldNENE() {
    assertEquals("Append NE/NE list", "(a, b, 1, 2, 3)", ne2.execute(algo, ne1).toString());
    assertEquals("Append NE/NE list", "(1, 2, 3, a, b)", ne1.execute(algo, ne2).toString());
  }

  public void testEmpty() {
    assertEquals("Append Empty/Empty list", "()", mt.execute(Append.Singleton, fac, mt).toString());
  }
  
  public void testEmptyNE() {
    assertEquals("Append Empty/NE list", "(1, 2, 3)", mt.execute(Append.Singleton, fac, ne1).toString());
  }

  public void testNEEmpty() {
    assertEquals("Append NE/Empty list", "(a, b)", ne2.execute(Append.Singleton, fac, mt).toString());
  }
  
  public void testNENE() {
    assertEquals("Append NE/NE list", "(a, b, 1, 2, 3)", ne2.execute(Append.Singleton, fac, ne1).toString());
    assertEquals("Append NE/NE list", "(1, 2, 3, a, b)", ne1.execute(Append.Singleton, fac, ne2).toString());
  }
}