package listFW.test;

import java.io.*;
import java.lang.reflect.*;

import listFW.*;
import listFW.factory.*;

public class TestReflection {
  public static void main(String[] args) throws IOException {
    final IListFactory fac = CompositeListFactory.Singleton;    
    IList mt = fac.makeEmptyList();
    IList ne1 = fac.makeNEList(1, fac.makeNEList(2, fac.makeNEList(3, fac.makeNEList(4, mt))));
    System.out.println(ne1);
    
    System.out.println("Enter class name:");
    System.out.println("  listFW.Add");
    System.out.println("  listFW.Multiply");
    System.out.print(" >");
    BufferedReader r = new BufferedReader(new InputStreamReader(System.in));
    String className = r.readLine();
    System.out.print("Enter initial integer:");
    Integer init = new Integer(r.readLine());
    
    try {
      Class opClass = Class.forName(className);
      Constructor opCtor = opClass.getConstructor();
      ILambda op = (ILambda)opCtor.newInstance();
      
      IListAlgo algo = new FoldR(op);
      
      System.out.println(ne1.execute(algo, init));
    }
    catch(Exception e1) {
      System.err.println("Exception: "+e1);
      e1.printStackTrace(System.err);
    }
  }
}
