package listFW.test;

import junit.framework.TestCase;

import listFW.*;
import listFW.factory.*;

/**
 * Testing reversing a list.
 * @author DXN
 */
public class TestReverse extends TestCase {
  final IListFactory fac = CompositeListFactory.Singleton;    
  IList mt = fac.makeEmptyList();
  
  // same f as in TestAppend!
  ILambda f = new ILambda() {
    public Object apply(Object... params) {
      return fac.makeNEList(params[0], (IList)params[1]);
    }
  };
  
  // but we fold in a different direction, and use a different initial value
  IListAlgo algo = new FoldL(f);
  
  public void testFoldEmpty() {
    assertEquals("Reverse Empty list", "()", mt.execute(algo, mt).toString());
  }
  
  public void testFoldNonEmpty() {
    IList L = fac.makeNEList("a", mt);
    assertEquals("Reverse (a)", "(a)", L.execute(algo, mt).toString());
    L = fac.makeNEList("b", L);
    assertEquals("Reverse ( b, a)", "(a, b)", L.execute(algo, mt).toString());
    L = fac.makeNEList("c", L);
    assertEquals("Reverse ( c, b, a)", "(a, b, c)", L.execute(algo, mt).toString());
  }
  
  public void testEmpty() {
    assertEquals("Reverse Empty list", "()", mt.execute(Reverse.Singleton, fac).toString());
  }
  
  public void testNonEmpty() {
    IList L = fac.makeNEList("a", mt);
    assertEquals("Reverse (a)", "(a)", L.execute(Reverse.Singleton, fac).toString());
    L = fac.makeNEList("b", L);
    assertEquals("Reverse ( b, a)", "(a, b)", L.execute(Reverse.Singleton, fac).toString());
    L = fac.makeNEList("c", L);
    assertEquals("Reverse ( c, b, a)", "(a, b, c)", L.execute(Reverse.Singleton, fac).toString());
  }

}