public class Box<E> {
  E data;
  
  public Box(E data) {
    this.data = data;
  }
  
  public E getData() {
    return data;
  }
  
  public void setData(E data) {
    this.data = data;
  }
  
  public <T> boolean holdsSubClassOf(Box<T> b) {
    T d_inp = b.getData();
    E d_this = getData();
    return d_inp.getClass().isAssignableFrom(d_this.getClass());
  }
  
  public void copyFrom(Box<? extends E> b) {
    this.data = b.getData(); // b.getData() is a subclass of this.data
  }
  
  public void copyTo(Box<? super E> b) {
    b.data = this.data; // b.data is a superclass of this.data
  }
}
