
package Counter;

public class Counter
{
	private ACounterState counterState;
	/**
	 * @param count 
	 */
	public Counter(int count)
	{
		setCounterState(ZeroState.Singleton());
		setCount(count);
	}


	public Counter decrement()
	{
		return counterState.decrement(this);
	}

	public Counter increment()
	{
		return counterState.increment(this);
	}

	public int getCount()
	{
		return counterState.getCount(this);
	}

	/**
	 * @param count 
	 */
	public void setCount(int count)
	{ 
		counterState.setCount(this, count);
	}

	/**
	 * @param algo 
	 * @param param 
	 */
	public Object execute(ICounterAlgo algo, Object param)
	{
		return counterState.execute(this, algo, param);
	}

	/** @SBGen Method set counterState   */
	void setCounterState(ACounterState counterState)
	{
		// SBgen: Assign variable
		this.counterState = counterState;
	}
}

