package LRSVisitor;
import LRStructure.*;
// This visitor appends a value to the end of a list
public class LRSAppend implements IAlgo
{
	/** @SBGen Singleton Variable   */
	private static LRSAppend singleton = null;	/** @SBGen Singleton   */
	public static LRSAppend Singleton()
	{
		// SBgen: Ensure single instance
		if (singleton == null) 
			singleton = new LRSAppend();
		return(singleton);
		// SBgen: End singleton
	}
	/** @SBGen Constructor   */
	private LRSAppend()
	{
	}

    public Object nullCase(LRStruct host, Object param)
    {
        // The empty node is the end of the list, so insert the new data here.
        host.insertAsFirst(param);
		return(null);
    }

    public Object nonNullCase(LRStruct host, Object param)
    {
        // The non-empty node is not the end of the list, so recurse.
        return host.getRest().execute(this,param);
    }
}
