package LRSVisitor;
import LRStructure.*;
import java.awt.*;
// This visitor prints (by appending) a LRS made of CompareObjecs
// onto a TextArea AWT object.  
// It does not clear the text area before writing to it.
// Returns null always.
public class LRSPrint
	implements IAlgo
{
	/** @SBGen Constructor   */
	public LRSPrint()
	{
		}

    public Object nullCase(LRStruct host, Object param)
    {
        return(null);   // Nothing to print here.
    }

    public Object nonNullCase(LRStruct host, Object param)
    {
        TextArea device = (TextArea) param;  // saves recasting all the time
		// appends the integer value of the data as a new line onto the TextArea
		device.append(((Integer)host.getFirst()).toString() +'\n');
		return host.getRest().execute(this,device);  // recurse on the rest of the list
    }
}