
package LRSVisitor;
import Counter.*;
import LRStructure.*;

/**
* Returns the nth element in a LRS.
*/
public class Nth implements IAlgo, ICounterAlgo
{
	/** @SBGen Singleton Variable   */
	private static Nth Singleton = null;	/** @SBGen Constructor   */
	private Nth()
	{
	}

	/**
	 * @param host 
	 * @param param 
	 * @return 
	 */
	public Object nullCase(LRStruct host, Object param)
	{
		return (null); // No such element exists
	}

	/**
	 * @param host 
	 * @param param 
	 * @return 
	 */
	public Object nonNullCase(LRStruct host, Object param)
	{
		return (((Counter) param).execute(this, host)); //
	}

	/**
	 * @param host Counter to be operated on
	 * @param param LRS to be operated on
   * @return the first element.
	 */
	public Object zeroCase(Counter host, Object param)
	{
		// param is the host of the null/nonNull cases.
		return (((LRStruct)param).getFirst ());
	}

	/**
	 * @param host 
	 * @param param 
	 * @return 
	 */
	public Object nonZeroCase(Counter host, Object param)
	{
		return (((LRStruct) param).getRest ().execute (this, host.decrement ()));
	}

	/**
	 * @return 
	 * @SBGen Singleton 
	 */
	public static Nth Singleton()
	{
		// SBgen: Ensure single instance
		if (Singleton == null) 
			Singleton = new Nth();
		return(Singleton);
		// SBgen: End singleton
	}
}

