
package LRSVisitor;

import Counter.*;
import LRStructure.*;

public class NthCdr implements IAlgo, ICounterAlgo
{
	/**
	 * @param host LRS to be operated on
	 * @param param A Counter object
	 */
	public Object nullCase(LRStruct host, Object param)
	{
		return(host);
	}

	/**
	 * @param host LRS to be operated on
	 * @param param A Counter object
	 */
	public Object nonNullCase(LRStruct host, Object param)
	{
		return( ((Counter) param).execute(this, host) );
	}

	/**
	 * @param host Counter to be operated on
	 * @param param LRS to be operated on
	 */
	public Object zeroCase(Counter host, Object param)
	{
		// param is the host of the null/nonNull cases.
		return(param);
	}

	/**
	 * @param host Counter to be operated on
	 * @param param LRS to be operated on
	 */
	public Object nonZeroCase(Counter host, Object param)
	{
		return( ((LRStruct) param).getRest().execute(this, host.decrement()) );
	}
}

