
package LRSVisitor;
import LRStructure.*;

/**
 * Removes the leading consecutive multiple of an integer from the host.
 */
public class RemLeadMods implements IAlgo
{
	/** @SBGen Singleton Variable   */
	private static RemLeadMods instance = null;	/** @SBGen Constructor   */
	private RemLeadMods()
	{
	}

	/**
	 * @param host 
	 * @param param 
	 * @return 
	 */
	public Object nullCase(LRStruct host, Object param)
	{
		return (null); // Nothing to remove.
	}

	/**
	 * Removes leading multiples of param from host.
	 * @param host the LRS to filter.
	 * @param param the factor to be filtered
	 * @return 
	 */
	public Object nonNullCase(LRStruct host, Object param)
	{
		if (((Integer) host.getFirst ()).intValue () % ((Integer)param).intValue () == 0)
		{
			host.removeFirst ();
			host.execute (this, param);
		} 
		return (host.getFirst ()); // 
	}

	/**
	 * @return 
	 * @SBGen Singleton 
	 */
	public static RemLeadMods Singleton()
	{
		// SBgen: Ensure single instance
		if (instance == null) 
			instance = new RemLeadMods();
		return(instance);
		// SBgen: End singleton
	}
}

