package LRSVisitor;
import LRStructure.*;
// This visitor removes the node whose value matches the param's value.
// Returns true if remove was successful, returns false othewise.

public class RemoveItem implements IAlgo
{
	/** @SBGen Singleton Variable   */
	private static RemoveItem singleton = null;	/** @SBGen Singleton   */
	public static RemoveItem Singleton()
	{
		// SBgen: Ensure single instance
		if (singleton == null) 
			singleton = new RemoveItem();
		return(singleton);
		// SBgen: End singleton
	}
	/** @SBGen Constructor   */
	private RemoveItem()
	{
	}

    public Object nullCase(LRStruct host, Object param)
    {
        return new Boolean(false);  // item not found.
    }

    public Object nonNullCase(LRStruct host, Object param)
    {
        Integer item = (Integer) param;  // saves recasting all the time

        // Remove this node if the local data equals the param.
        if (item.equals((Integer)host.getFirst()))
        {
            host.removeFirst();
            return new Boolean(true);
        }
        else   // otherwise recurse and return the result
        {
            return host.getRest().execute(this, param);
        }
    }
}