package LRSVisitor;

import Counter.*;
import LRStructure.*;

/**
* Removes and returns the nth element in a LRS.
*/
public class RemoveNth implements IAlgo, ICounterAlgo
{
	/** @SBGen Singleton Variable   */
	private static RemoveNth Singleton = null;

	/**
	 * @param Singleton 
	 * @SBGen Constructor assigns Singleton
	 */
	private RemoveNth()
	{
		// SBgen: Assign variable
		this.Singleton = Singleton;
	}
	/**
	 * @param host 
	 * @param param 
	 * @return 
	 */
	public Object zeroCase(Counter host, Object param)
	{
		// param is the host of the null/nonNull cases.
		return (((LRStruct)param).removeFirst ());
	}

	/**
	 * @param host 
	 * @param param 
	 * @return 
	 */
	public Object nonZeroCase(Counter host, Object param)
	{
		return (((LRStruct) param).getRest ().execute (this, host.decrement ()));
	}

	/**
	 * @param host 
	 * @param param 
	 * @return 
	 */
	public Object nullCase(LRStruct host, Object param)
	{
		return (null); // No such element exists.
	}

	/**
	 * @param host 
	 * @param param 
	 * @return 
	 */
	public Object nonNullCase(LRStruct host, Object param)
	{
		return (((Counter) param).execute(this, host)); //
	}

	/**
	 * @return 
	 * @SBGen Singleton assigns Singleton
	 */
	public static RemoveNth Singleton()
	{
		// SBgen: Ensure single instance
		if (Singleton == null) 
			Singleton = new RemoveNth();
		return(Singleton);
		// SBgen: End singleton
	}
}

