package LRStructure;
/**
 * <<host>>
 * linear recursive structure
 */
public class LRStruct
{
	/** @SBGen Variable (,head,,128)   */
	private AState _head;

	/** @SBGen Constructor   */
	public LRStruct()
	{
		_head = NullState.Singleton();
		}

	/**
	 * @param dat data to insert at this node
	 */
	public final void insertAsFirst(Object dat)
	{
		_head.insertAsFirst(dat, this);
	}

	/**
	 * @return Returns this node's first
	 */
	public final Object removeFirst()
	{
		return _head.removeFirst(this);
	}

	/**
	 * @return Gets the data from this node
	 */
	public final Object getFirst()
	{
		return _head.getFirst(this);
	}

	/**
	 * @param dat new data for this node
	 */
	public final void setFirst(Object dat)
	{
		_head.setFirst(dat, this);
	}

	/**
	 * @return gets the rest of the structure
	 */
	public final LRStruct getRest()
	{
		return _head.getRest(this);
	}

	/**
	 * @param tail sets a new tail for this node
	 */
	public final void setRest(LRStruct tail)
	{
		_head.setRest(tail, this);
	}

	/**
	 * @param head
	 */
	final void setHead(AState head)
	{
		_head = head;
	}

	/**
	 * @return
	 */
	final AState getHead()
	{
		return(_head);
	}


	public final Object execute(IAlgo visitor, Object param)
	{
	    return getHead().execute(visitor, param, this);
	}
}

