
package LRStructure;

import LazyLRSEvaluators.*;
/**
 * Decorator for NonNullState, adding lazy evaluation capability.
 * @author D. X. Nguyen & S. B. Wong
 */
public class LazyNonNullState extends AState
{
	/** @SBGen Variable (,strategy,,64)   */
	ALazyEval aLazyEval;
	/** @SBGen Variable (,,decorator,64)   */
	NonNullState nonNullState;

	LazyNonNullState(Object first, ALazyEval aLazyEval)
	{
		nonNullState = new NonNullState (first);
		this.aLazyEval = aLazyEval;
	}

	LRStruct getRest(LRStruct owner)
	{
		eval (owner);
		return (nonNullState.getRest (owner));
	}

	void setRest(LRStruct tail, LRStruct owner)
	{
		eval (owner);
		nonNullState.setRest (tail, owner);
	}

	void setFirst(Object first, LRStruct owner)
	{
		nonNullState.setFirst (first, owner);
	}

	void insertAsFirst(Object dat, LRStruct owner)
	{
		nonNullState.insertAsFirst (dat, owner);
 	}

	Object removeFirst(LRStruct owner)
	{
		  eval (owner);
    	return (nonNullState.removeFirst (owner));
	}

	void eval(LRStruct owner)
	{
		owner.setHead (nonNullState);  // owner no longer needs lazy eval.
 		owner.setRest (aLazyEval.nextLRS ());		 // But owner's tail does!
	}

	Object getFirst(LRStruct owner)
	{
		return (nonNullState.getFirst (owner)); // lazy eval not needed.
	}

	Object execute(IAlgo visitor, Object param, LRStruct host)
	{
		return (nonNullState.execute (visitor, param, host));
	}
}

