package LRStructure;
import java.awt.TextArea;
import java.awt.*;
/**
 * <<concrete state>>
 * non-null LRS node

 */
class NonNullState
	extends AState
{
	/** @SBGen Variable (,tail,,64)   */
	private LRStruct _tail;
	private Object _first;

	/**
	 * @param _first 
	 * @SBGen Constructor assigns _first
	 */
	NonNullState(Object _first)
	{
		// SBgen: Assign variable
		this._first = _first;
  	  _tail = new LRStruct();
	}

	/**
	 * @param owner 
	 * @return n
	 */
	LRStruct getRest(LRStruct owner)
	{
		return(_tail);
	}

	/**
	 * @param owner
	 * @return n
	 */
	Object getFirst(LRStruct owner)
	{
		return(_first);
	}

	/**
	 * @param tail
	 * @param owner
	 */
	void setRest(LRStruct tail, LRStruct owner)
	{
		_tail = tail;
	}

	/**
	 * @param first
	 * @param owner
	 */
	void setFirst(Object first, LRStruct owner)
	{
		_first = first;
	}

	/**
	 * @param dat
	 * @param owner
	 */
	void insertAsFirst(Object dat, LRStruct owner)
	{
	    NonNullState newNode = new NonNullState(dat);
      AState tmpHead = owner.getHead();    // tmpHead = owner._head
      owner.setHead(newNode);              // owner._head = newNode
   	  owner.getRest().setHead(tmpHead);  // newNode._tail._head = tmpHead
 	}

	/**
	 * @param owner
	 * @return
	 */
	Object removeFirst(LRStruct owner)
	{
	    Object dat = owner.getFirst();       // dat = _dat
    	owner.setHead(owner.getRest().getHead()); // owner._head = _tail._head
    	return(dat);
	}

    Object execute(IAlgo visitor, Object param, LRStruct owner)
    {
        return visitor.nonNullCase(owner, param);
    }
}

