package LRStructure;
import java.awt.TextArea;
import java.awt.*;
/**
 * <<concrete state, singleton>>
 * null LRS node
 */
class NullState
	extends AState                                                                                   
{
	/** @SBGen Singleton Variable   */
	private static NullState singleton = null;
	/** @SBGen Constructor   */
	private NullState()
	{
		}
	/** @SBGen Singleton   */
  static NullState Singleton()
	{
		// SBgen: Ensure single instance
		if (singleton == null) 
			singleton = new NullState();
		return(singleton);
		// SBgen: End singleton
	}

	/**
	 * @param owner 
	 * @return n
	 */
	LRStruct getRest(LRStruct owner)
	{
		return(owner);
	}

	/**
	 * @param owner 
	 * @return n
	 */
	Object getFirst(LRStruct owner)
	{
		return(null);
	}

	/**
	 * @param tail 
	 * @param owner 
	 */
	void setRest(LRStruct tail, LRStruct owner)
	{
	}

	/**
	 * @param dat 
	 * @param owner 
	 */
	void setFirst(Object dat, LRStruct owner)
	{
	}

	/**
	 * @param dat 
	 * @param owner 
	 */
	void insertAsFirst(Object dat, LRStruct owner)
	{
	    owner.setHead(new NonNullState(dat));
	}

	/**
	 * @param owner 
	 * @return 
	 */
	Object removeFirst(LRStruct owner)
	{
		return(null);
	}

    Object execute(IAlgo visitor, Object param, LRStruct owner)
    {
        return visitor.nullCase(owner, param);
    }

}

