/*
DXN, May 18. 99: don't think host is needed in the next method in general.  The
lazy evaluator should carry all needed information to compute the next element in
the sequence, irrespective of what the host has.
*/
package LazyLRSEvaluators;

import LRStructure.*;
public class LazyFibEval extends ALazyEval
{
  // f(n) = f(n-1) + f(n-2).
	private int _fn1; // f(n-1)
  private int _fn2; // f(n-2)

  public LazyFibEval (int fn2, int fn1)
  {
    _fn1 = fn1;
    _fn2 = fn2;
  }

	public LRStruct nextLRS()
	{
	    int fn = _fn1 + _fn2;
   	 _fn2 = _fn1;
   	 _fn1 = fn;
    	return  makeLazyLRS (new Integer(_fn2));
	}

	/**
	 * @return 
	 */
	public LRStruct makeLRS() // I want to be able to makeLazyLRS at any time.
	{
		LRStruct lrs = new LRStruct();
		lrs.insertAsFirst(new Integer(_fn2));
		lrs.setRest (nextLRS());
		return lrs;
	}
}

