
package LazyLRSEvaluators;

import LRStructure.*;
import LRSVisitor.*; // skip leading modulo.
import Logic.*;

/**
 * Given a filter factor v and a source list src, lazy evaluate  to remove all
 * multiples of v from src.
 */
public class LazyFilterEval extends ALazyEval implements IAlgo, ILogicAlgo
{
	/** @SBGen Variable (,filter source,,64)   */
	private LRStruct src;
	/** @SBGen Variable (,strategy,,64)   */
	private APredicate aPredStrategy;

	public LazyFilterEval(APredicate aPredStrategy, LRStruct src)
	{
		this.src = src;
		this.aPredStrategy = aPredStrategy;
	}


	public LRStruct nextLRS()
	{
		return makeLRS ();
	}

	/**
	 * Removes (lazily) all elements from src that don't satisfy the predicate and returns the result.
	 * @return a filtered LRStruct.
	 */
	public LRStruct makeLRS()
	{
		return (LRStruct) src.execute( this , null);
	}

	public Object nullCase(LRStruct host, Object param)
	{
		return (host); // done
	}

	public Object nonNullCase(LRStruct host, Object param)
	{
		return (aPredStrategy.isTrue(host.getFirst())).execute(this, host);  //check the predicate
	}

	public Object trueCase(ILogical host, Object param)
	{
			src = (LRStruct) param; // found beginning of list that satisfies predicate
//			return LRSFactory.Singleton().makeLRS (src.removeFirst(), this);
      return makeLazyLRS(src.removeFirst());//make list with next value and this evaluator
	}

	public Object falseCase(ILogical host, Object param)
	{
			return ((LRStruct) param).getRest().execute(this, null); // keep looking
	}
}

