
package Logic;

/**
 * @dependency Logic.Logical uses
 */
public class LogicFactory
{
	/** @SBGen Singleton Variable   */
	private static LogicFactory instance;

	/** @SBGen Constructor   */
	private LogicFactory()
	{
	}

	/**
	 * @return 
	 * @SBGen Singleton 
	 */
	public static LogicFactory Singleton()
	{
		// SBgen: Ensure single instance
		if (instance == null) 
			instance = new LogicFactory();
		return(instance);
		// SBgen: End singleton
	}

	/**
	 * @param state 
	 */
	public ILogical makeLogical(boolean state)
	{
		return new Logical(state);
	}
}

