package demo;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

import LRStructure.*;
import LRSVisitor.*;
import Counter.*;
import LazyLRSEvaluators.*;
import Logic.*;

public class Frame1 extends JFrame {
  GridLayout gridLayout1 = new GridLayout();
  JTextArea textArea1 = new JTextArea();
  JPanel jPanel2 = new JPanel();
  JLabel jLabel1 = new JLabel();
  JLabel jLabel2 = new JLabel();
  JLabel jLabel3 = new JLabel();
  JTextField textField1 = new JTextField();
  JTextField textField2 = new JTextField();
  JTextField textFieldLength = new JTextField();
  JPanel jPanel7 = new JPanel();
  JPanel jPanel8 = new JPanel();
  JPanel jPanel3 = new JPanel();
  JPanel jPanel4 = new JPanel();
  JPanel jPanel5 = new JPanel();
  JPanel jPanel6 = new JPanel();
  JRadioButton chkBxConst = new JRadioButton();
  JRadioButton chkBxInc = new JRadioButton();
  JRadioButton chkBxFibonacci = new JRadioButton();
  JRadioButton chkBxFilter = new JRadioButton();
  JRadioButton chkBxRangeFilter = new JRadioButton();
  JRadioButton chkBxMultMNodFilter = new JRadioButton();
  JRadioButton chkBxSieve = new JRadioButton();
  ButtonGroup buttonGroup = new ButtonGroup();

  //Construct the frame
  public Frame1() {
    enableEvents(AWTEvent.WINDOW_EVENT_MASK);
    try  {
      jbInit();
    }
    catch(Exception e) {
      e.printStackTrace();
    }
    buttonGroup.add(chkBxConst);
    buttonGroup.add(chkBxInc);
    buttonGroup.add(chkBxFibonacci);
    buttonGroup.add(chkBxFilter);
    buttonGroup.add(chkBxRangeFilter);
    buttonGroup.add(chkBxMultMNodFilter);
    buttonGroup.add(chkBxSieve);
  }

  //Component initialization
  private void jbInit() throws Exception  {
    gridLayout1.setColumns(3);
    gridLayout1.setHgap(2);
    gridLayout1.setVgap(2);
    this.getContentPane().setLayout(gridLayout1);
    this.setSize(new Dimension(810, 737));
    this.setTitle("Lazy Evaluation of LRStructs");
    jLabel1.setFont(new java.awt.Font("Dialog", 1, 18));
    jLabel1.setHorizontalAlignment(SwingConstants.RIGHT);
    jLabel1.setLabelFor(textFieldLength);
    jLabel1.setText("display length:");
    jLabel2.setText("Input/Output A:");
    jLabel3.setText("Input/Output B:");
    textField1.setColumns(6);
    textField1.setHorizontalAlignment(SwingConstants.CENTER);
    textField1.setBackground(Color.lightGray);
    textField1.setFont(new java.awt.Font("SansSerif", 1, 20));
    textField1.setBorder(null);
    textField1.setOpaque(false);
    textField1.setText("1");
    textField2.setFont(new java.awt.Font("SansSerif", 1, 20));
    textField2.setBorder(null);
    textField2.setOpaque(false);
    textField2.setText("1");
    textField2.setColumns(6);
    textField2.setHorizontalAlignment(SwingConstants.CENTER);
    textFieldLength.setBackground(Color.lightGray);
    textFieldLength.setFont(new java.awt.Font("Dialog", 1, 20));
    textFieldLength.setBorder(null);
    textFieldLength.setOpaque(false);
    textFieldLength.setPreferredSize(new Dimension(102, 27));
    textFieldLength.setText("15");
    textFieldLength.setHorizontalAlignment(SwingConstants.CENTER);
    textFieldLength.addActionListener(new java.awt.event.ActionListener()
		{
			public void actionPerformed(ActionEvent e)
			{
				textFieldLength_actionPerformed(e);
			}
		});
    jPanel7.setLayout(gridLayout6);
    jPanel7.setBackground(Color.cyan);
    jPanel7.setPreferredSize(new Dimension(227, 500));
    jPanel8.setLayout(gridLayout7);
    jPanel3.setLayout(borderLayout2);
    jPanel4.setLayout(borderLayout1);
    jPanel5.setLayout(borderLayout3);
    jPanel6.setLayout(gridLayout8);
    jLabel1.setText("Display Length:");
    jLabel2.setFont(new java.awt.Font("Dialog", 1, 18));
    jLabel2.setHorizontalAlignment(SwingConstants.RIGHT);
    jLabel2.setText("Input/Output A:");
    jLabel3.setBackground(Color.white);
    jLabel3.setFont(new java.awt.Font("Dialog", 1, 18));
    jLabel3.setHorizontalAlignment(SwingConstants.RIGHT);
    jLabel3.setText("Input/Output B:");
    chkBxConst.setToolTipText("value <- A");
    chkBxConst.setOpaque(false);
    chkBxConst.setText("Constant List");
    chkBxConst.setFont(new java.awt.Font("Dialog", 1, 18));
    chkBxConst.addActionListener(new java.awt.event.ActionListener() {

      public void actionPerformed(ActionEvent e) {
        chkBxConst_actionPerformed(e);
      }
    });
    chkBxInc.addActionListener(new java.awt.event.ActionListener() {

      public void actionPerformed(ActionEvent e) {
        chkBxInc_actionPerformed(e);
      }
    });
    chkBxInc.setText("Arithmetic List");
    chkBxInc.setFont(new java.awt.Font("Dialog", 1, 18));
    chkBxInc.setToolTipText("x0 <- A, inc <- B");
    chkBxInc.setOpaque(false);
    chkBxFibonacci.setOpaque(false);
    chkBxFibonacci.setText("Fibonacci List");
    chkBxFibonacci.setFont(new java.awt.Font("Dialog", 1, 18));
    chkBxFibonacci.addActionListener(new java.awt.event.ActionListener() {

      public void actionPerformed(ActionEvent e) {
        chkBxFibonacci_actionPerformed(e);
      }
    });
    chkBxFilter.setToolTipText("value <- A");
    chkBxFilter.setOpaque(false);
    chkBxFilter.setText("Modulo Filter");
    chkBxFilter.setFont(new java.awt.Font("Dialog", 1, 18));
    chkBxFilter.addActionListener(new java.awt.event.ActionListener() {

      public void actionPerformed(ActionEvent e) {
        chkBxFilter_actionPerformed(e);
      }
    });
    chkBxRangeFilter.setToolTipText("min <- A, max <- B");
    chkBxRangeFilter.setOpaque(false);
    chkBxRangeFilter.setText("Range Filtered List");
    chkBxRangeFilter.setFont(new java.awt.Font("Dialog", 1, 18));
    chkBxRangeFilter.addActionListener(new java.awt.event.ActionListener() {

      public void actionPerformed(ActionEvent e) {
        chkBxRangeFilter_actionPerformed(e);
      }
    });
    chkBxMultMNodFilter.setToolTipText("value 1 <- A, value 2 <- B");
    chkBxMultMNodFilter.setOpaque(false);
    chkBxMultMNodFilter.setText("Multiple Modulo Filtered List");
    chkBxMultMNodFilter.setFont(new java.awt.Font("Dialog", 1, 18));
    chkBxMultMNodFilter.addActionListener(new java.awt.event.ActionListener() {

      public void actionPerformed(ActionEvent e) {
        chkBxMultMNodFilter_actionPerformed(e);
      }
    });
    chkBxSieve.setOpaque(false);
    chkBxSieve.setText("Prime Numbers List");
    chkBxSieve.setFont(new java.awt.Font("Dialog", 1, 18));
    chkBxSieve.addActionListener(new java.awt.event.ActionListener() {

      public void actionPerformed(ActionEvent e) {
        chkBxSieve_actionPerformed(e);
      }
    });
    textArea1.setMargin(new Insets(10, 50, 10, 10));
    textArea1.setEditable(false);
    textArea1.setFont(new java.awt.Font("Serif", 1, 30));
    selSortBtn.setBackground(Color.yellow);
    selSortBtn.setFont(new java.awt.Font("Dialog", 1, 18));
    selSortBtn.setText("Selection Sort  <");
    selSortBtn.addActionListener(new java.awt.event.ActionListener()
    {

      public void actionPerformed(ActionEvent e)
      {
        selSortBtn_actionPerformed(e);
      }
    });
    jPanel2.setLayout(gridLayout5);
    jPanel2.setBackground(new java.awt.Color(135, 104, 151));
    selSortBtn1.setText("Selection Sort  >");
    selSortBtn1.addActionListener(new java.awt.event.ActionListener()
    {

      public void actionPerformed(ActionEvent e)
      {
        selSortBtn1_actionPerformed(e);
      }
    });
    selSortBtn1.setFont(new java.awt.Font("Dialog", 1, 18));
    selSortBtn1.setBackground(Color.yellow);
    nthCdrBtn.setText("n\'th Cdr");
    nthCdrBtn.addActionListener(new java.awt.event.ActionListener()
    {

      public void actionPerformed(ActionEvent e)
      {
        nthCdrBtn_actionPerformed(e);
      }
    });
    nthCdrBtn.setFont(new java.awt.Font("Dialog", 1, 18));
    nthCdrBtn.setToolTipText("n <- A");
    nthCdrBtn.setBackground(Color.yellow);
    trimBtn.setText("Trim at n\'th");
    trimBtn.addActionListener(new java.awt.event.ActionListener()
    {

      public void actionPerformed(ActionEvent e)
      {
        trimBtn_actionPerformed(e);
      }
    });
    trimBtn.setFont(new java.awt.Font("Dialog", 1, 18));
    trimBtn.setToolTipText("n <- A");
    trimBtn.setBackground(Color.yellow);
    btnSetNth.setText("Set n\'th");
    btnSetNth.addActionListener(new java.awt.event.ActionListener()
    {

      public void actionPerformed(ActionEvent e)
      {
        btnSetNth_actionPerformed(e);
      }
    });
    btnSetNth.setFont(new java.awt.Font("Dialog", 1, 18));
    btnSetNth.setToolTipText("n <- A, value <- B");
    btnSetNth.setBackground(Color.yellow);
    btnRemNth.setText("Remove n\'th");
    btnRemNth.addActionListener(new java.awt.event.ActionListener()
    {

      public void actionPerformed(ActionEvent e)
      {
        btnRemNth_actionPerformed(e);
      }
    });
    btnRemNth.setFont(new java.awt.Font("Dialog", 1, 18));
    btnRemNth.setToolTipText("n <- A, B <- value");
    btnRemNth.setBackground(Color.yellow);
    btnNth.setText("n\'th Element");
    btnNth.addActionListener(new java.awt.event.ActionListener()
    {

      public void actionPerformed(ActionEvent e)
      {
        btnNth_actionPerformed(e);
      }
    });
    btnNth.setFont(new java.awt.Font("Dialog", 1, 18));
    btnNth.setToolTipText("n <- A,  B <- value");
    btnNth.setBackground(Color.yellow);
    sumBtn.setText("Sum");
    sumBtn.addActionListener(new java.awt.event.ActionListener()
    {

      public void actionPerformed(ActionEvent e)
      {
        sumBtn_actionPerformed(e);
      }
    });
    sumBtn.setFont(new java.awt.Font("Dialog", 1, 18));
    sumBtn.setToolTipText("A <- sum");
    sumBtn.setBackground(Color.yellow);
    appendBtn.setText("Append");
    appendBtn.addActionListener(new java.awt.event.ActionListener()
    {

      public void actionPerformed(ActionEvent e)
      {
        appendBtn_actionPerformed(e);
      }
    });
    appendBtn.setFont(new java.awt.Font("Dialog", 1, 18));
    appendBtn.setToolTipText("value <- A");
    appendBtn.setBackground(Color.yellow);
    getLastBtn.setText("Get Last");
    getLastBtn.addActionListener(new java.awt.event.ActionListener()
    {

      public void actionPerformed(ActionEvent e)
      {
        getLastBtn_actionPerformed(e);
      }
    });
    getLastBtn.setFont(new java.awt.Font("Dialog", 1, 18));
    getLastBtn.setToolTipText("A <- value");
    getLastBtn.setBackground(Color.yellow);
    removeBtn.setText("Remove Car");
    removeBtn.addActionListener(new java.awt.event.ActionListener()
    {

      public void actionPerformed(ActionEvent e)
      {
        removeBtn_actionPerformed(e);
      }
    });
    removeBtn.setFont(new java.awt.Font("Dialog", 1, 18));
    removeBtn.setToolTipText("A <- value");
    removeBtn.setBackground(Color.yellow);
    ordInsertBtn.setText("Ordered Insert +");
    ordInsertBtn.addActionListener(new java.awt.event.ActionListener()
    {

      public void actionPerformed(ActionEvent e)
      {
        ordInsertBtn_actionPerformed(e);
      }
    });
    ordInsertBtn.setFont(new java.awt.Font("Dialog", 1, 18));
    ordInsertBtn.setToolTipText("value <- A");
    ordInsertBtn.setBackground(Color.yellow);
    consBtn.setText("Cons");
    consBtn.addActionListener(new java.awt.event.ActionListener()
    {

      public void actionPerformed(ActionEvent e)
      {
        consBtn_actionPerformed(e);
      }
    });
    consBtn.setFont(new java.awt.Font("Dialog", 1, 18));
    consBtn.setToolTipText("car <- A ");
    consBtn.setBackground(Color.yellow);
    clearBtn.setText("Clear");
    clearBtn.addActionListener(new java.awt.event.ActionListener() {

      public void actionPerformed(ActionEvent e) {
        clearBtn_actionPerformed(e);
      }
    });
    clearBtn.setFont(new java.awt.Font("Dialog", 1, 18));
    clearBtn.setBackground(Color.yellow);
    gridLayout5.setColumns(1);
    gridLayout5.setHgap(2);
    gridLayout5.setRows(0);
    gridLayout5.setVgap(2);
    gridLayout6.setColumns(1);
    gridLayout6.setHgap(2);
    gridLayout6.setRows(0);
    gridLayout6.setVgap(2);
    gridLayout7.setColumns(1);
    gridLayout7.setHgap(2);
    gridLayout7.setRows(0);
    gridLayout7.setVgap(2);
    gridLayout8.setColumns(1);
    gridLayout8.setHgap(2);
    gridLayout8.setRows(0);
    gridLayout8.setVgap(2);
    jPanel8.setBackground(Color.white);
    jPanel3.setBorder(BorderFactory.createRaisedBevelBorder());
    jPanel4.setBorder(BorderFactory.createRaisedBevelBorder());
    jPanel5.setBorder(BorderFactory.createRaisedBevelBorder());
    this.getContentPane().add(jPanel6, null);
    jPanel6.add(jPanel8, null);
    jPanel8.add(jPanel3, null);
    jPanel3.add(jLabel1, BorderLayout.CENTER);
    jPanel3.add(textFieldLength, BorderLayout.EAST);
    jPanel8.add(jPanel4, null);
    jPanel4.add(jLabel2, BorderLayout.CENTER);
    jPanel4.add(textField1, BorderLayout.EAST);
    jPanel8.add(jPanel5, null);
    jPanel5.add(jLabel3, BorderLayout.CENTER);
    jPanel5.add(textField2, BorderLayout.EAST);
    jPanel6.add(jPanel7, null);
    jPanel7.add(chkBxConst, null);
    jPanel7.add(chkBxInc, null);
    jPanel7.add(chkBxFilter, null);
    jPanel7.add(chkBxFibonacci, null);
    jPanel7.add(chkBxRangeFilter, null);
    jPanel7.add(chkBxMultMNodFilter, null);
    jPanel7.add(chkBxSieve, null);
    this.getContentPane().add(jPanel2, null);
    jPanel2.add(clearBtn, null);
    jPanel2.add(consBtn, null);
    jPanel2.add(ordInsertBtn, null);
    jPanel2.add(removeBtn, null);
    jPanel2.add(getLastBtn, null);
    jPanel2.add(appendBtn, null);
    jPanel2.add(sumBtn, null);
    jPanel2.add(btnNth, null);
    jPanel2.add(btnRemNth, null);
    jPanel2.add(btnSetNth, null);
    jPanel2.add(trimBtn, null);
    jPanel2.add(nthCdrBtn, null);
    jPanel2.add(selSortBtn1, null);
    jPanel2.add(selSortBtn, null);
    this.getContentPane().add(jScrollPane1, null);
    jScrollPane1.getViewport().add(textArea1, null);
  }

  //Overridden so we can exit on System Close
  protected void processWindowEvent(WindowEvent e) {
    super.processWindowEvent(e);
    if(e.getID() == WindowEvent.WINDOW_CLOSING) {
      System.exit(0);
    }
  }

  LRStruct list = new LRStruct();
  JScrollPane jScrollPane1 = new JScrollPane();
  JButton selSortBtn = new JButton();
  JButton selSortBtn1 = new JButton();
  JButton nthCdrBtn = new JButton();
  JButton trimBtn = new JButton();
  JButton btnSetNth = new JButton();
  JButton btnRemNth = new JButton();
  JButton btnNth = new JButton();
  JButton sumBtn = new JButton();
  JButton appendBtn = new JButton();
  JButton getLastBtn = new JButton();
  JButton removeBtn = new JButton();
  JButton ordInsertBtn = new JButton();
  JButton consBtn = new JButton();
  JButton clearBtn = new JButton();
  GridLayout gridLayout5 = new GridLayout();
  GridLayout gridLayout6 = new GridLayout();
  GridLayout gridLayout7 = new GridLayout();
  GridLayout gridLayout8 = new GridLayout();
  BorderLayout borderLayout1 = new BorderLayout();
  BorderLayout borderLayout2 = new BorderLayout();
  BorderLayout borderLayout3 = new BorderLayout();

  void textFieldLength_actionPerformed(ActionEvent e)
  {
		printList();
  }

  void chkBxConst_actionPerformed(ActionEvent e)
  {
    list = new LazyConstantEval (Integer.parseInt(textField1.getText())).makeLRS ();
    printList ();
  }

  void chkBxInc_actionPerformed(ActionEvent e)
  {
    list = new LazyIncEval (Integer.parseInt(textField1.getText()),
                            Integer.parseInt(textField2.getText())).makeLRS ();
    printList ();
  }

  void chkBxFibonacci_actionPerformed(ActionEvent e)
  {
	  list =  (new LazyFibEval(0, 1)).makeLRS();
		printList();
  }

  void chkBxFilter_actionPerformed(ActionEvent e)
  {
    list = new LazyFilterEval (new ModPredStrategy(Integer.parseInt (textField1.getText ())), list).makeLRS ();
    printList ();
  }

  void chkBxRangeFilter_actionPerformed(ActionEvent e)
  {
    list = new LazyFilterEval (new RangePredicate(
                      Integer.parseInt (textField1.getText ()),
                      Integer.parseInt (textField2.getText ())
                      ),list).makeLRS ();
    printList ();
  }

  void chkBxMultMNodFilter_actionPerformed(ActionEvent e)
  {
    list = new LazyFilterEval (new MultModPredicate(
                      Integer.parseInt (textField1.getText ()),
                      Integer.parseInt (textField2.getText ())
                      ),list).makeLRS ();
    printList ();
  }

  void chkBxSieve_actionPerformed(ActionEvent e)
  {
	  list =  (new LazySieveEval()).makeLRS();
		printList();
  }

  void printList()
	{
		textArea1.setText("");
		list.execute(new LRSPrintN(textArea1), new Counter(Integer.parseInt(textFieldLength.getText()) + 1));
	}

  void clearBtn_actionPerformed(ActionEvent e)
  {
    list.execute(LRSClear.Singleton(), null);
		printList();

  }

  void consBtn_actionPerformed(ActionEvent e)
  {
    list.insertAsFirst(new Integer(textField1.getText()));
    printList();
  }

  void ordInsertBtn_actionPerformed(ActionEvent e)
  {
		list.execute( LRSOrderedInsert.Singleton(), new Integer(textField1.getText()));
		printList();
  }

  void removeBtn_actionPerformed(ActionEvent e)
  {
		textField1.setText(((Integer)list.removeFirst()).toString());
		printList();
  }

  void getLastBtn_actionPerformed(ActionEvent e)
  {
		textField1.setText(((Integer)list.execute(GetLast.Singleton(),list)).toString());
  }

  void appendBtn_actionPerformed(ActionEvent e)
  {
		list.execute( LRSAppend.Singleton(), new Integer(textField1.getText()));
		printList();
  }

  void sumBtn_actionPerformed(ActionEvent e)
  {
		textField1.setText(((Integer) list.execute(LRSSum.Singleton(), null)).toString());
  }

  void btnNth_actionPerformed(ActionEvent e)
  {
		textField2.setText(
    ((Integer) list.execute (Nth.Singleton (), new Counter (Integer.parseInt (textField1.getText ())))).toString());
  }

  void btnRemNth_actionPerformed(ActionEvent e)
  {
		textField2.setText(
    ((Integer) list.execute (RemoveNth.Singleton (), new Counter (Integer.parseInt (textField1.getText ())))).toString());
    printList ();
  }

  void btnSetNth_actionPerformed(ActionEvent e)
  {
    int ix = Integer.parseInt (textField1.getText ());
    Integer dat = new Integer (Integer.parseInt (textField2.getText ()));
    list.execute (SetNth.Singleton (), SetNth.MakeInputDat (ix, list, dat));
    printList ();
  }

  void trimBtn_actionPerformed(ActionEvent e)
  {
		list.execute(new LRSTrim(), new Counter(Integer.parseInt(textField1.getText())));
		printList();
  }

  void nthCdrBtn_actionPerformed(ActionEvent e)
  {
		list = (LRStruct) list.execute(new NthCdr(), new Counter(Integer.parseInt(textField1.getText())));
		printList();
  }

  void selSortBtn1_actionPerformed(ActionEvent e)
  {
		list.execute(new SelectionSort(GetMax.Singleton()), null);
		printList();
  }

  void selSortBtn_actionPerformed(ActionEvent e)
  {
		list.execute(new SelectionSort(GetMin.Singleton()), null);
		printList();
  }

}
