
import parser.*;
import parser.visitor.*;

import token.*;
import token.tokenizer.*;

import sample.*;

import javax.swing.*;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.io.FileNotFoundException;


public class RDPFrame extends JFrame {
  private static final long serialVersionUID = 2007111140354L;
  /**
   * Content pane.
   */
  private JPanel contentPane;
  
  /**
   * Output text area.
   */
  private JTextArea outputTA = new JTextArea();
  
  /**
   * Top panel.
   */
  private JPanel topPanel = new JPanel();
  
  /**
   * Bottom scroll pane.
   */
  private JScrollPane scrollPane = new JScrollPane();
  
  /**
   * File name input field.
   */
  private JTextField inpFileTF = new JTextField();
  
  /**
   * Button to parse original grammar file.
   */
  private JButton parseOrigBtn = new JButton();
  
  /**
   * Button to parse XML file.
   */
  private JButton parseXMLBtn = new JButton();
  
  /**
   * Button to semantically check the parsed file.
   */
  private JButton checkBtn = new JButton();
  
  
  /**
   * Tokenizer.
   */
  private ITokenizer tok;
  
  /**
   * Constructor for the frame.
   */
  public RDPFrame() {
    enableEvents(AWTEvent.WINDOW_EVENT_MASK);
    try {
      jbInit();
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }
  
  /**
   * Initialize GUI components.
   */
  private void jbInit() {
    //setIconImage(Toolkit.getDefaultToolkit().createImage(RDPFrame.class.getResource("[Your Icon]")));
    contentPane = (JPanel) this.getContentPane();
    contentPane.setLayout(new BorderLayout());
    
    this.setSize(new Dimension(616, 317));
    this.setTitle("Frame Title");
    
    inpFileTF.setMinimumSize(new Dimension(100, 21));
    inpFileTF.setPreferredSize(new Dimension(100, 21));
    inpFileTF.setText("xml1.txt");
    
    parseOrigBtn.setText("Parse Orig");
    parseOrigBtn.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        parseOrigBtn_actionPerformed(e);
      }
    });
    
    parseXMLBtn.setText("Parse XML");
    parseXMLBtn.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        parseXMLBtn_actionPerformed(e);
      }
    });
    
    checkBtn.setText("Check XML result");
    checkBtn.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        checkBtn_actionPerformed(e);
      }
    });
    
    topPanel.add(inpFileTF, null);
    topPanel.add(parseOrigBtn, null);
    topPanel.add(parseXMLBtn, null);
    topPanel.add(checkBtn, null);
    
    contentPane.add(scrollPane, BorderLayout.CENTER);
    contentPane.add(topPanel, BorderLayout.NORTH);
    scrollPane.getViewport().add(outputTA, null);
  }
  
  /**
   * Overridden so we can exit when window is closed.
   *
   * @param e window event
   */
  protected void processWindowEvent(WindowEvent e) {
    super.processWindowEvent(e);
    if (e.getID() == WindowEvent.WINDOW_CLOSING) {
      System.exit(0);
    }
  }
  
  /**
   * Make original grammar parser.
   *  
   *  E ::= F E1
   *  F ::= F1 | F2
   *  F1 ::= NumToken
   *  F2 ::= IdToken
   *  E1 ::= E1a | Empty
   *  E1a ::= + E
   * 
   * @throws FileNotFoundException thrown if file is not found
   */
  protected ITokVisitorFact makeOrigParser() throws FileNotFoundException {
    tok = new Tokenizer1(inpFileTF.getText());
    
    
    //---- Student to comment out the code below ------
    
    // The old way of instantiating the grammar:
    /**
    E1aFact e1aFac = new E1aFact(tok);
    ITokVisitorFact eFact = new EFact(tok,
                      new FFact(tok, 
                                new F1Fact(tok), 
                                new F2Fact(tok)),
                      new E1Fact(tok, 
                                 e1aFac, 
                                 new EmptyFact(tok)));
    
    e1aFac.setParseEFactory((EFact)eFact);
    */
    
    //----- Student to comment out the code above ---------
    
    // STUDENT TO COMPLETE:
    // Replace the above code with code that only uses 
    // SequenceFact, CombinationFact, SimpleFact, MTSymbolFact, 
    // and/or MultiSequenceFact
    
    // The new way of instantiating the old grammar:

    ProxyFact eFact_Proxy = new ProxyFact();
    
    ITokVisitorFact eFact = new MultiSequenceFact("E", tok,
                                             new CombinationFact("F", tok, 
                                                                 new TerminalSymbolFact("Num", tok), 
                                                                 new TerminalSymbolFact("Id", tok)),
                                             new CombinationFact("E1", tok, 
                                                                 new MultiSequenceFact("E1a", tok, 
                                                                                       new TerminalSymbolFact("+", tok), 
                                                                                       eFact_Proxy), 
                                                                 new MTSymbolFact(tok)));
    
    eFact_Proxy.setFact(eFact);

    
    System.err.println("Parser Factory = " + eFact);
    
    return eFact;
  }
  
  static final AGramSymVisitor<String,String> toStringHelp = new AGramSymVisitor<String, String>(new IGramSymVisitorCmd<String,String>() {
      public String apply(String index, IGrammarSymbol host, String... params) {
          // terminal case
          TerminalSymbol h = (TerminalSymbol)host;
          return "|_ "+h.getClass().getName()+": "+h.toString();
      }
  }) { };
  static {
      toStringHelp.setCmd("Sequence", new IGramSymVisitorCmd<String,String>() {
          public String apply(String index, IGrammarSymbol host, String... params) {
              // sequence case
              SequenceSymbol h = (SequenceSymbol)host;
              return "|_ "+h.getClass().getName()+"\n"+
                  params[0]+h.getSymbol1().execute(toStringHelp,params[0]+"|  ")+"\n"+
                  params[0]+h.getSymbol2().execute(toStringHelp,params[0]+"  ");
          }
      });
      toStringHelp.setCmd("MTSymbol", new IGramSymVisitorCmd<String,String>() {
          public String apply(String index, IGrammarSymbol host, String... params) {
              // empty case
              return "|_ "+host.getClass().getName();
          }
      });
  }
  static final AGramSymVisitor<String,String> toString = new AGramSymVisitor<String, String>(new IGramSymVisitorCmd<String,String>() {
      public String apply(String index, IGrammarSymbol host, String... params) {
          // terminal case
          TerminalSymbol h = (TerminalSymbol)host;
          return h.getClass().getName()+": "+h.toString();
      }
  }) {
      {
          setCmd("MTSymbol", new IGramSymVisitorCmd<String,String>() {
              public String apply(String index, IGrammarSymbol host, String... params) {
                  // empty case
                  return host.getClass().getName();
              }
          });
          setCmd("Sequence", new IGramSymVisitorCmd<String,String>() {
              public String apply(String index, IGrammarSymbol host, String... params) {
                  // sequence case
                  SequenceSymbol h = (SequenceSymbol)host;
                  return params[0]+h.getClass().getName()+"\n"+
                      h.getSymbol1().execute(toStringHelp,"|  ")+"\n"+
                      h.getSymbol2().execute(toStringHelp,"   ");
              }
          });
      }
  };

  /**
   * Parse file.
   *
   * @param e action event
   */
  @SuppressWarnings("unchecked")
  void parseOrigBtn_actionPerformed(ActionEvent e) {
    try {
      ITokVisitorFact origParseFact = makeOrigParser();
      
      ITokVisitor<IGrammarSymbol, Object> parser = origParseFact.makeVisitor();
      System.err.println("Parser visitor = " + parser);
      
      result = tok.getNextToken().execute(parser);
      System.err.println("Result = " + result);
      
      StringBuilder sb = new StringBuilder();
      sb.append(result.toString());
      sb.append('\n');
      sb.append(result.execute(toString, ""));
      AAST a = result.execute(ToModelAlgo.Singleton);
      sb.append("\n\n");
      sb.append(a.execute(InFixFormatter.Singleton));
      outputTA.setText(sb.toString());
    }
    catch (Exception e1) {
      StringBuffer sb = new StringBuffer();
      sb.append(e1.toString());
      sb.append('\n');
      StackTraceElement[] ste = e1.getStackTrace();
      for (int i = 0; i < ste.length; ++i) {
        sb.append('\t');
        sb.append(ste[i].toString());
        sb.append('\n');
      }
      outputTA.setText(sb.toString());
      outputTA.setCaretPosition(0);
      e1.printStackTrace();
    }
  }
  
  /**
   * Make XML parser.
   *
   * TaggedElt ::= < Id > AXML </ Id > 
   * AXML  ::=  NEXML | MTSymbol   
   * NEXML ::=  AElement AXML 
   * AElement ::=  Id | TaggedElt 
   * 
   * Notes:
   * MTSymbol = empty token
   * "</" is a single token above, not two tokens
   * 
   * @throws FileNotFoundException thrown if file is not found
   */
  protected ITokVisitorFact makeXMLParser() throws FileNotFoundException {
    tok = new XMLTokenizer(inpFileTF.getText());  
    
    ITokVisitorFact leftBracketFact = new TerminalSymbolFact("<", tok);
    ITokVisitorFact rightBracketFact = new TerminalSymbolFact(">", tok);
    ITokVisitorFact forwardSlashFact = new TerminalSymbolFact("/", tok);
    ITokVisitorFact idFact = new TerminalSymbolFact("Id", tok);
    ITokVisitorFact leftBracketForwardSlashFact = new TerminalSymbolFact("</", tok);
    
    // STUDENT TO COMPLETE
    
    
    ProxyFact taggedElt_Proxy = new ProxyFact();
    
    ProxyFact aXML_Proxy = new ProxyFact();
        
    ITokVisitorFact aXML = new CombinationFact("AXML", tok,
                                          new MultiSequenceFact("NEXML", tok,
                                                                new CombinationFact("AElement", tok,
                                                                                    idFact, taggedElt_Proxy),
                                                                aXML_Proxy), 
                                          new MTSymbolFact(tok));
    aXML_Proxy.setFact(aXML);
    
    ITokVisitorFact taggedElt = new MultiSequenceFact("EFac", tok,
                                                 leftBracketFact, idFact, rightBracketFact,
                                                 aXML, 
                                                 leftBracketForwardSlashFact, idFact, rightBracketFact);
    
    taggedElt_Proxy.setFact(taggedElt);
    
    System.err.println("Parser Factory = " + taggedElt);
    
    return taggedElt;
  }
  
  IGrammarSymbol result;
  
  /**
   * Parse file.
   *
   * @param e action event
   */
  void parseXMLBtn_actionPerformed(ActionEvent e) {
    try {
      ITokVisitorFact xmlParseFact = makeXMLParser();
      
      ITokVisitor<IGrammarSymbol, Object> parser = xmlParseFact.makeVisitor();
      System.err.println("Parser visitor = " + parser);
      
      result = tok.getNextToken().execute(parser);
      System.err.println("Result = " + result);
      
      StringBuilder sb = new StringBuilder();
      sb.append(result.toString());
      sb.append('\n');
      sb.append(result.execute(toString, ""));
      outputTA.setText(sb.toString());
    }
    catch (Exception e1) {
      StringBuffer sb = new StringBuffer();
      sb.append(e1.toString());
      sb.append('\n');
      StackTraceElement[] ste = e1.getStackTrace();
      for (int i = 0; i < ste.length; ++i) {
        sb.append('\t');
        sb.append(ste[i].toString());
        sb.append('\n');
      }
      outputTA.setText(sb.toString());
      outputTA.setCaretPosition(0);
      e1.printStackTrace();
    }
  }
  
  void checkBtn_actionPerformed(ActionEvent e) {
    boolean isOk = result.execute(CheckMatchingTagsAlgo.Singleton);
    outputTA.append("\n"+"Check result: "+ isOk);
  }
  
  
}