package parser;

import token.*;
import token.tokenizer.*;
import extvisitor.*;
import util.*;

/**
 * Factory for a simple non-terminal that references a single token.
 */
public class TerminalSymbolFact extends ATokVisitorFact {
  /**
   * Initializer lambda for this factory.
   */
  private ILambda<Object, Object> _initializer = new ILambda<Object, Object>() {
    public Object apply(Object... nu) {
      // change state to no-op
      _initializer = new NoOpLambda<Object>();
      
      // nothing to initialize
      return null;
    }
  };
  
  String _name;
  /**
   * Constructor for the F1 factory.
   *
   * @param tkz tokenizer to use
   * @param name the name that references the single token
   */
  public TerminalSymbolFact(String name, ITokenizer tkz) {
    super(tkz);
    _name = name;
  }
  
  private void addCmdTo(ATokVisitor<IGrammarSymbol, Object> target) {
    target.setCmd(_name, new IExtVisitorCmd<IGrammarSymbol, String, Object, Token>() {
      public IGrammarSymbol apply(String idx, Token host, Object... inp) {
        System.out.println("TerminalSymbolFact("+_name+")");
        return new TerminalSymbol(_name,(Token)host);
      }
    });
  }
  
  /**
   * Make a token visitor to parse an E1a non-terminal.
   *
   * @return token visitor
   */
  public ATokVisitor<IGrammarSymbol, Object> makeVisitor() {
    initialize();
    
    return new ATokVisitor<IGrammarSymbol, Object>() {
      {
        addCmdTo(this);
      }
    };
  }
  
  /**
   * Make a token visitor that will process the combination of this 
   * or the other given symbol 
   *
   * @param other The visitor for the other symbol in the combination 
   * @return A token visitor
   */
  public ATokVisitor<IGrammarSymbol, Object> makeCombinedVisitor(ATokVisitor<IGrammarSymbol, Object> other) {
    initialize();
    
    return new ATokVisitor<IGrammarSymbol, Object>(other) {
      {
        addCmdTo(this);
      }
    };
  }
  
  /**
   * Make the visitor.
   */
  private void initialize() {
    _initializer.apply((Object) null);
    
  }
}

