package sample2;

import extvisitor.*;

public class InFixFormatter extends AExtVisitor</*R=*/String,/*I=*/String,/*P=*/Void,/*H=*/AAST> {
    public final static InFixFormatter Singleton = new InFixFormatter();
    private InFixFormatter() {
        super(new IExtVisitorCmd</*R=*/String,/*I=*/String,/*P=*/Void,/*H=*/AAST>() {
            public String apply(String index, AAST host, Void... params) {
                throw new AssertionError("will never happen");
            }
        });
        // set up visitor cases here
        setCmd("Tuesday", new IExtVisitorCmd</*R=*/String,/*I=*/String,/*P=*/Void,/*H=*/AAST>() {
            public String apply(String index, AAST host, Void... params) {
                return String.valueOf(((IntLeaf)host).getValue());
            }
        });
        setCmd("Thursday", new IExtVisitorCmd</*R=*/String,/*I=*/String,/*P=*/Void,/*H=*/AAST>() {
            public String apply(String index, AAST host, Void... params) {
                return ((VarLeaf)host).getValue();
            }
        });
        setCmd("Monday", new IExtVisitorCmd</*R=*/String,/*I=*/String,/*P=*/Void,/*H=*/AAST>() {
            public String apply(String index, AAST host, Void... params) {
                Add h = (Add)host;
                return "("+h.getLHS().execute(Singleton)+" + "+h.getRHS().execute(Singleton)+")";
            }
        });
        setCmd("Wednesday", new IExtVisitorCmd</*R=*/String,/*I=*/String,/*P=*/Void,/*H=*/AAST>() {
            public String apply(String index, AAST host, Void... params) {
                Multiply h = (Multiply)host;
                return "("+h.getLHS().execute(Singleton)+" * "+h.getRHS().execute(Singleton)+")";
            }
        });
    }
}

