/*
 * Decompiled with CFR 0.152.
 */
package view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import model.AUnit;
import model.Measurement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TempCalcView
extends JPanel {
    private JComboBox _leftUnitBox;
    private JTextField _leftTextField;
    private JComboBox _rightUnitBox;
    private JTextField _rightTextField;

    public TempCalcView(List<AUnit> units) {
        try {
            this.jbInit(units);
            this.jbInit(units);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit(List<AUnit> units) {
        this.setSize(new Dimension(540, 380));
        this.setLayout(new BorderLayout());
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BoxLayout(topPanel, 0));
        this._leftTextField = new JTextField("0.0");
        this._leftTextField.setPreferredSize(new Dimension(80, 30));
        this._leftTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TempCalcView.this.handleLeftChange();
            }
        });
        this._leftUnitBox = new JComboBox<Object>(units.toArray());
        this._leftUnitBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TempCalcView.this.handleRightChange();
            }
        });
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        p.add(this._leftUnitBox);
        p.add(this._leftTextField);
        topPanel.add(p);
        this._rightTextField = new JTextField("0.0");
        this._rightTextField.setPreferredSize(new Dimension(80, 30));
        this._rightTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TempCalcView.this.handleRightChange();
            }
        });
        this._rightUnitBox = new JComboBox<Object>(units.toArray());
        this._rightUnitBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TempCalcView.this.handleLeftChange();
            }
        });
        this._rightUnitBox.setSelectedIndex(Math.min(1, units.size() - 1));
        p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        p.add(this._rightUnitBox);
        p.add(this._rightTextField);
        topPanel.add(p);
        this.add((Component)topPanel, "Center");
        this.handleLeftChange();
    }

    private void handleLeftChange() {
        DecimalFormat df = new DecimalFormat("#0.0");
        double entered = Double.valueOf(this._leftTextField.getText());
        double conv = ((AUnit)this._rightUnitBox.getSelectedItem()).convertTo(new Measurement(entered, (AUnit)this._leftUnitBox.getSelectedItem())).getValue();
        this._rightTextField.setText(df.format(conv));
    }

    private void handleRightChange() {
        DecimalFormat df = new DecimalFormat("#0.0");
        double entered = Double.valueOf(this._rightTextField.getText());
        double conv = ((AUnit)this._leftUnitBox.getSelectedItem()).convertTo(new Measurement(entered, (AUnit)this._rightUnitBox.getSelectedItem())).getValue();
        this._leftTextField.setText(df.format(conv));
    }
}

