/*
 * Decompiled with CFR 0.152.
 */
package model;

import junit.framework.TestCase;
import model.AUnit;
import model.IBijection;
import model.Measurement;
import model.temperature.Celsius;
import model.temperature.Fahrenheit;
import model.temperature.Kelvin;

public class ModelTest
extends TestCase {
    public void testCtoF() {
        Celsius c = new Celsius();
        Fahrenheit f = new Fahrenheit();
        ModelTest.assertEquals((Object)new Measurement(212.0, f), (Object)f.convertTo(new Measurement(100.0, c)));
        ModelTest.assertEquals((Object)new Measurement(32.0, f), (Object)f.convertTo(new Measurement(0.0, c)));
        ModelTest.assertEquals((Object)new Measurement(-148.0, f), (Object)f.convertTo(new Measurement(-100.0, c)));
    }

    public void testFtoC() {
        Celsius c = new Celsius();
        Fahrenheit f = new Fahrenheit();
        ModelTest.assertEquals((Object)new Measurement(100.0, c), (Object)c.convertTo(new Measurement(212.0, f)));
        ModelTest.assertEquals((Object)new Measurement(0.0, c), (Object)c.convertTo(new Measurement(32.0, f)));
        ModelTest.assertEquals((Object)new Measurement(-100.0, c), (Object)c.convertTo(new Measurement(-148.0, f)));
    }

    public void testCtoK() {
        Celsius c = new Celsius();
        Kelvin k = new Kelvin();
        ModelTest.assertEquals((Object)new Measurement(373.2, k), (Object)k.convertTo(new Measurement(100.0, c)));
        ModelTest.assertEquals((Object)new Measurement(273.2, k), (Object)k.convertTo(new Measurement(0.0, c)));
        ModelTest.assertEquals((Object)new Measurement(173.2, k), (Object)k.convertTo(new Measurement(-100.0, c)));
    }

    public void testKtoC() {
        Celsius c = new Celsius();
        Kelvin k = new Kelvin();
        ModelTest.assertEquals((Object)new Measurement(100.0, c), (Object)c.convertTo(new Measurement(373.2, k)));
        ModelTest.assertEquals((Object)new Measurement(-273.2, c), (Object)c.convertTo(new Measurement(0.0, k)));
        ModelTest.assertEquals((Object)new Measurement(0.0, c), (Object)c.convertTo(new Measurement(273.2, k)));
    }

    public void testFtoK() {
        Fahrenheit f = new Fahrenheit();
        Kelvin k = new Kelvin();
        ModelTest.assertEquals((Object)new Measurement(373.2, k), (Object)k.convertTo(new Measurement(212.0, f)));
        ModelTest.assertEquals((Object)new Measurement(273.2, k), (Object)k.convertTo(new Measurement(32.0, f)));
        ModelTest.assertEquals((Object)new Measurement(173.2, k), (Object)k.convertTo(new Measurement(-148.0, f)));
    }

    public void testKtoF() {
        Fahrenheit f = new Fahrenheit();
        Kelvin k = new Kelvin();
        ModelTest.assertEquals((Object)new Measurement(212.0, f), (Object)f.convertTo(new Measurement(373.2, k)));
        ModelTest.assertEquals((Object)new Measurement(-459.76, f), (Object)f.convertTo(new Measurement(0.0, k)));
        ModelTest.assertEquals((Object)new Measurement(32.0, f), (Object)f.convertTo(new Measurement(273.2, k)));
    }

    public void testCtoC() {
        Celsius c = new Celsius();
        ModelTest.assertEquals((Object)new Measurement(100.0, c), (Object)c.convertTo(new Measurement(100.0, c)));
        ModelTest.assertEquals((Object)new Measurement(0.0, c), (Object)c.convertTo(new Measurement(0.0, c)));
        ModelTest.assertEquals((Object)new Measurement(-100.0, c), (Object)c.convertTo(new Measurement(-100.0, c)));
    }

    public void testKtoK() {
        Kelvin k = new Kelvin();
        ModelTest.assertEquals((Object)new Measurement(0.0, k), (Object)k.convertTo(new Measurement(0.0, k)));
        ModelTest.assertEquals((Object)new Measurement(273.2, k), (Object)k.convertTo(new Measurement(273.2, k)));
        ModelTest.assertEquals((Object)new Measurement(373.2, k), (Object)k.convertTo(new Measurement(373.2, k)));
    }

    public void testCustom() {
        Celsius c = new Celsius();
        AUnit custom1 = new AUnit("custom1"){
            private final IBijection<Double, Double> _func;
            private final IBijection<Double, Double> _inverse;
            {
                this._func = new IBijection<Double, Double>(){

                    @Override
                    public IBijection<Double, Double> getInverse() {
                        return _inverse;
                    }

                    @Override
                    public Double apply(Double param) {
                        return param / 2.0;
                    }
                };
                this._inverse = new IBijection<Double, Double>(){

                    @Override
                    public IBijection<Double, Double> getInverse() {
                        return _func;
                    }

                    @Override
                    public Double apply(Double param) {
                        return param * 2.0;
                    }
                };
            }

            @Override
            protected IBijection<Double, Double> getConversionFunction() {
                return this._func;
            }
        };
        ModelTest.assertEquals((Object)new Measurement(100.0, c), (Object)c.convertTo(new Measurement(200.0, custom1)));
        ModelTest.assertEquals((Object)new Measurement(0.0, c), (Object)c.convertTo(new Measurement(0.0, custom1)));
        ModelTest.assertEquals((Object)new Measurement(-100.0, c), (Object)c.convertTo(new Measurement(-200.0, custom1)));
        ModelTest.assertEquals((Object)new Measurement(100.0, custom1), (Object)custom1.convertTo(new Measurement(50.0, c)));
        ModelTest.assertEquals((Object)new Measurement(20.0, custom1), (Object)custom1.convertTo(new Measurement(10.0, c)));
        ModelTest.assertEquals((Object)new Measurement(-100.0, custom1), (Object)custom1.convertTo(new Measurement(-50.0, c)));
        AUnit custom2 = new AUnit("custom2"){
            private final IBijection<Double, Double> _func;
            private final IBijection<Double, Double> _inverse;
            {
                this._func = new IBijection<Double, Double>(){

                    @Override
                    public IBijection<Double, Double> getInverse() {
                        return _inverse;
                    }

                    @Override
                    public Double apply(Double param) {
                        return param + 10.0;
                    }
                };
                this._inverse = new IBijection<Double, Double>(){

                    @Override
                    public IBijection<Double, Double> getInverse() {
                        return _func;
                    }

                    @Override
                    public Double apply(Double param) {
                        return param - 10.0;
                    }
                };
            }

            @Override
            protected IBijection<Double, Double> getConversionFunction() {
                return this._func;
            }
        };
        ModelTest.assertEquals((Object)new Measurement(90.0, custom2), (Object)custom2.convertTo(new Measurement(200.0, custom1)));
        ModelTest.assertEquals((Object)new Measurement(-10.0, custom2), (Object)custom2.convertTo(new Measurement(0.0, custom1)));
        ModelTest.assertEquals((Object)new Measurement(-110.0, custom2), (Object)custom2.convertTo(new Measurement(-200.0, custom1)));
        ModelTest.assertEquals((Object)new Measurement(120.0, custom1), (Object)custom1.convertTo(new Measurement(50.0, custom2)));
        ModelTest.assertEquals((Object)new Measurement(40.0, custom1), (Object)custom1.convertTo(new Measurement(10.0, custom2)));
        ModelTest.assertEquals((Object)new Measurement(-80.0, custom1), (Object)custom1.convertTo(new Measurement(-50.0, custom2)));
    }
}

