/*
 * Decompiled with CFR 0.152.
 */
package view.console;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.util.List;
import model.AUnit;
import model.Measurement;
import view.IView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConsoleView
implements IView {
    private List<AUnit> _units;
    private BufferedReader _br = new BufferedReader(new InputStreamReader(System.in));

    public ConsoleView(List<AUnit> units) {
        if (units.size() < 2) {
            throw new IllegalArgumentException("Need at least two units.");
        }
        this._units = units;
    }

    @Override
    public void run() {
        System.out.println("Convert temperature between arbitrary scales.");
        String s = null;
        do {
            System.out.println("Available units:");
            int i = 0;
            for (AUnit u : this._units) {
                System.out.println("  " + String.valueOf(++i) + ": " + u.toString());
            }
            i = this.integerChoice("Type '1' .. '" + String.valueOf(this._units.size()) + "' to convert from the respective scale, or '0' to add a scale.", 0, this._units.size() + 1);
            if (i == 0) {
                this.addUnit();
                s = "y";
                continue;
            }
            this.convertFrom(this._units.get(i - 1));
            System.out.println("Do you want to convert more temperatures? ");
            s = this.multipleChoice("Press 'y' for yes, 'n' for no.", "y", "n");
        } while (s.equals("y"));
    }

    private String multipleChoice(String prompt, String ... choices) {
        String s = null;
        boolean repeat = true;
        block2: do {
            System.out.print(prompt + " ");
            try {
                s = this._br.readLine();
            }
            catch (IOException ioe) {
                continue;
            }
            repeat = true;
            for (String c : choices) {
                if (!c.equals(s)) continue;
                repeat = false;
                continue block2;
            }
        } while (repeat);
        return s;
    }

    private int integerChoice(String prompt, int min, int max) {
        int i = 0;
        do {
            System.out.print(prompt + " ");
            try {
                i = Integer.valueOf(this._br.readLine());
            }
            catch (NumberFormatException nfe) {
            }
            catch (IOException ioe) {
                // empty catch block
            }
        } while (i < min || i >= max);
        return i;
    }

    private void convertFrom(AUnit source) {
        System.out.println();
        boolean repeat = true;
        do {
            System.out.print("Please enter temperature in " + source.toString() + ": ");
            try {
                double d = Double.valueOf(this._br.readLine());
                Measurement m = new Measurement(d, source);
                StringBuilder sb = new StringBuilder();
                sb.append(m);
                for (AUnit dest : this._units) {
                    if (dest == source) continue;
                    sb.append(" = ");
                    sb.append(dest.convertTo(m));
                }
                System.out.println(sb.toString());
                repeat = false;
            }
            catch (NumberFormatException nfe) {
            }
            catch (IOException ioe) {
                // empty catch block
            }
        } while (repeat);
    }

    private void addUnit() {
        System.out.println();
        boolean repeat = true;
        do {
            System.out.print("Enter the class name for the scale to be added: ");
            try {
                Class<?> unitClass;
                String className = this._br.readLine();
                if (className.equals("") || !AUnit.class.isAssignableFrom(unitClass = Class.forName(className))) continue;
                Constructor<?> unitCtor = unitClass.getConstructor(new Class[0]);
                AUnit unit = (AUnit)unitCtor.newInstance(new Object[0]);
                this._units.add(unit);
                repeat = false;
            }
            catch (Exception exception) {
                // empty catch block
            }
        } while (repeat);
    }
}

