/*
 * Decompiled with CFR 0.152.
 */
package view.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import model.AUnit;
import model.Measurement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConversionView
extends JFrame {
    private List<UnitField> _unitFields;

    public ConversionView(List<AUnit> units) {
        super("Conversions");
        try {
            this.jbInit(units);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit(List<AUnit> units) {
        this.setSize(new Dimension(540, 380));
        Container cp = this.getContentPane();
        cp.setLayout(new BorderLayout());
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BoxLayout(topPanel, 0));
        this._unitFields = new ArrayList<UnitField>(units.size());
        for (AUnit u : units) {
            UnitField f = new UnitField("0.0", u);
            f.setPreferredSize(new Dimension(80, 30));
            f.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ConversionView.this.handleChange((UnitField)e.getSource());
                }
            });
            JPanel p = new JPanel();
            p.setLayout(new BoxLayout(p, 1));
            p.add(new JLabel(u.toString()));
            p.add(f);
            topPanel.add(p);
            this._unitFields.add(f);
        }
        cp.add((Component)topPanel, "Center");
        this.handleChange(this._unitFields.get(0));
    }

    private void handleChange(UnitField source) {
        this.pack();
        DecimalFormat df = new DecimalFormat("#0.0");
        double entered = Double.valueOf(source.getText());
        for (UnitField uf : this._unitFields) {
            if (uf == source) continue;
            double conv = uf.getUnit().convertTo(new Measurement(entered, source.getUnit())).getValue();
            uf.setText(df.format(conv));
        }
    }

    private static class UnitField
    extends JTextField {
        private AUnit _unit;

        public UnitField(String text, AUnit unit) {
            super(text);
            this._unit = unit;
        }

        public AUnit getUnit() {
            return this._unit;
        }
    }
}

