/*
 * Decompiled with CFR 0.152.
 */
package view.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import model.AUnit;
import view.IView;
import view.InputStringDialog;
import view.TempCalcFrame;
import view.gui.ConversionView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardView
extends JPanel
implements IView {
    private TempCalcFrame _frame;
    private DefaultListModel _unitListModel = new DefaultListModel();
    private JList _unitList;
    private JPanel _unitPanel;

    public StandardView(List<AUnit> units) {
        for (AUnit u : units) {
            this._unitListModel.addElement(u);
        }
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void run() {
        this._frame.setVisible(true);
    }

    private void jbInit() {
        this.setSize(new Dimension(540, 380));
        this.setLayout(new BorderLayout());
        this._unitPanel = new JPanel();
        this._unitPanel.setLayout(new BorderLayout());
        this._unitPanel.add((Component)new JLabel("Select units to convert:"), "North");
        this._unitList = new JList(this._unitListModel);
        JScrollPane sp = new JScrollPane(this._unitList);
        this._unitPanel.add((Component)sp, "Center");
        this.add((Component)this._unitPanel, "Center");
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout());
        JButton convertBtn = new JButton("Convert...");
        convertBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                StandardView.this.convertBtnClicked(e);
            }
        });
        buttonPanel.add(convertBtn);
        JButton addBtn = new JButton("Add Unit...");
        addBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                StandardView.this.addBtnClicked(e);
            }
        });
        buttonPanel.add(addBtn);
        this.add((Component)buttonPanel, "South");
        this._frame = new TempCalcFrame(this, false);
    }

    private void addBtnClicked(ActionEvent e) {
        String className = new InputStringDialog((Frame)null, (Component)this, "Enter class name for unit to be added:").showDialog();
        if (!className.equals("")) {
            try {
                Class<?> unitClass = Class.forName(className);
                if (!AUnit.class.isAssignableFrom(unitClass)) {
                    throw new RuntimeException("Invalid unit class, superclass is not model.AUnit.");
                }
                Constructor<?> unitCtor = unitClass.getConstructor(new Class[0]);
                AUnit unit = (AUnit)unitCtor.newInstance(new Object[0]);
                this._unitListModel.addElement(unit);
            }
            catch (Exception e1) {
                JOptionPane.showMessageDialog(this, e1);
            }
        }
    }

    private void convertBtnClicked(ActionEvent e) {
        int count = this._unitList.getSelectedValues().length;
        if (count > 1) {
            ArrayList<AUnit> selectedUnits = new ArrayList<AUnit>(count);
            for (Object o : this._unitList.getSelectedValues()) {
                selectedUnits.add((AUnit)o);
            }
            ConversionView cv = new ConversionView(selectedUnits);
            cv.setLocationRelativeTo(this);
            cv.setVisible(true);
        } else {
            JOptionPane.showMessageDialog(this, "Please select two or more units.");
        }
    }
}

