/*
 * Decompiled with CFR 0.152.
 */
package view;

import java.awt.AWTError;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.lang.reflect.Constructor;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import model.AUnit;
import view.IView;
import view.InputStringDialog;
import view.SwingWorker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LauncherFrame
extends JFrame {
    private List<AUnit> _units;
    private JButton _addViewButton;

    public LauncherFrame(IView[] views, List<AUnit> units) {
        super("Temperature Calculator Launcher");
        Dimension screenSize;
        if (units.size() < 2) {
            throw new IllegalArgumentException("Need at least two units.");
        }
        this._units = units;
        this.setLayout(new GridLayout(0, 1));
        this.add(new JLabel("Please select view:"));
        for (IView v : views) {
            this.addViewButton(v);
        }
        this._addViewButton = new JButton("Add view...");
        this._addViewButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LauncherFrame.this.handleAddView();
            }
        });
        this.add(this._addViewButton);
        this.pack();
        try {
            Toolkit tk = Toolkit.getDefaultToolkit();
            screenSize = tk.getScreenSize();
        }
        catch (AWTError awe) {
            screenSize = new Dimension(640, 480);
        }
        Dimension frameSize = this.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        int x = screenSize.width / 2 - frameSize.width / 2;
        int y = screenSize.height / 2 - frameSize.height / 2;
        this.setLocation(x, y);
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        super.processWindowEvent(e);
        if (201 == e.getID()) {
            System.exit(0);
        }
    }

    private void addViewButton(final IView v) {
        JButton button = new JButton(v.getClass().getName());
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SwingWorker worker = new SwingWorker(){

                    public Object construct() {
                        v.run();
                        return null;
                    }
                };
                worker.start();
            }
        });
        this.add(button);
    }

    private void handleAddView() {
        String className = new InputStringDialog((Frame)null, (Component)this, "Enter class name for view to be added:").showDialog();
        if (!className.equals("")) {
            try {
                Class<?> viewClass = Class.forName(className);
                if (!IView.class.isAssignableFrom(viewClass)) {
                    throw new RuntimeException("Invalid view class, does not implement view.IView.");
                }
                Constructor<?> viewCtor = viewClass.getConstructor(List.class);
                IView view = (IView)viewCtor.newInstance(this._units);
                this.remove(this._addViewButton);
                this.addViewButton(view);
                this.add(this._addViewButton);
                this.pack();
            }
            catch (Exception e1) {
                JOptionPane.showMessageDialog(null, e1);
            }
        }
    }
}

