/*
 * Decompiled with CFR 0.152.
 */
package view;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import model.IModelAdapter;

public class TempCalcConsoleView {
    private IModelAdapter _modelAdapter;
    private BufferedReader _br = new BufferedReader(new InputStreamReader(System.in));

    public TempCalcConsoleView(IModelAdapter modelAdapter) {
        this._modelAdapter = modelAdapter;
    }

    public void run() {
        String s;
        System.out.println("Convert temperature between Celsius and Fahrenheit.");
        do {
            if ((s = this.multipleChoice("Press 'c' to convert C to F, or 'f' to convert F to c.", "c", "f")).equals("c")) {
                this.convertCtoF();
            } else {
                this.convertFtoC();
            }
            System.out.println("Do you want to convert more temperatures? ");
        } while ((s = this.multipleChoice("Press 'y' for yes, 'n' for no.", "y", "n")).equals("y"));
    }

    private String multipleChoice(String prompt, String ... choices) {
        String s = null;
        boolean repeat = true;
        block2: do {
            System.out.print(prompt + " ");
            try {
                s = this._br.readLine();
            }
            catch (IOException ioe) {
                continue;
            }
            repeat = true;
            for (String c : choices) {
                if (!c.equals(s)) continue;
                repeat = false;
                continue block2;
            }
        } while (repeat);
        return s;
    }

    private void convertCtoF() {
        System.out.println();
        boolean repeat = true;
        do {
            System.out.print("Please enter temperature in Celsius: ");
            try {
                double d = Double.valueOf(this._br.readLine());
                System.out.println(String.valueOf(d) + " C = " + String.valueOf(this._modelAdapter.convertCtoF(d)) + " F");
                repeat = false;
            }
            catch (NumberFormatException nfe) {
            }
            catch (IOException ioe) {
                // empty catch block
            }
        } while (repeat);
    }

    private void convertFtoC() {
        System.out.println();
        boolean repeat = true;
        do {
            System.out.print("Please enter temperature in Fahrenheit: ");
            try {
                double d = Double.valueOf(this._br.readLine());
                System.out.println(String.valueOf(d) + " F = " + String.valueOf(this._modelAdapter.convertFtoC(d)) + " C");
                repeat = false;
            }
            catch (NumberFormatException nfe) {
            }
            catch (IOException ioe) {
                // empty catch block
            }
        } while (repeat);
    }
}

