/*
 * Decompiled with CFR 0.152.
 */
package view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import model.IModelAdapter;

public class TempCalcView
extends JPanel {
    private JTextField _degFField;
    private JTextField _degCField;
    private JTextField _kelvinField;
    private IModelAdapter _modelAdapter;

    public TempCalcView(IModelAdapter modelAdapter) {
        this._modelAdapter = modelAdapter;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() {
        this.setSize(new Dimension(540, 380));
        this.setLayout(new BorderLayout());
        this._degCField = new JTextField("100.0");
        this._degCField.setPreferredSize(new Dimension(80, 30));
        this._degCField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TempCalcView.this.handleCelsiusChange();
            }
        });
        JPanel degCPanel = new JPanel();
        degCPanel.setLayout(new BoxLayout(degCPanel, 1));
        degCPanel.add(new JLabel("C"));
        degCPanel.add(this._degCField);
        this._degFField = new JTextField("212.0");
        this._degFField.setPreferredSize(new Dimension(80, 30));
        this._degFField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TempCalcView.this.handleFahrenheitChange();
            }
        });
        JPanel degFPanel = new JPanel();
        degFPanel.setLayout(new BoxLayout(degFPanel, 1));
        degFPanel.add(new JLabel("= F"));
        degFPanel.add(this._degFField);
        this._kelvinField = new JTextField("373.2");
        this._kelvinField.setPreferredSize(new Dimension(80, 30));
        this._kelvinField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TempCalcView.this.handleKelvinChange();
            }
        });
        JPanel kelvinPanel = new JPanel();
        kelvinPanel.setLayout(new BoxLayout(kelvinPanel, 1));
        kelvinPanel.add(new JLabel("= K"));
        kelvinPanel.add(this._kelvinField);
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BoxLayout(topPanel, 0));
        topPanel.add(degCPanel);
        topPanel.add(degFPanel);
        topPanel.add(kelvinPanel);
        this.add((Component)topPanel, "Center");
        this.handleCelsiusChange();
    }

    private void handleFahrenheitChange() {
        double degF = Double.valueOf(this._degFField.getText());
        DecimalFormat df = new DecimalFormat("#0.0");
        this._degCField.setText(df.format(this._modelAdapter.convertFtoC(degF)));
        this._kelvinField.setText(df.format(this._modelAdapter.convertFtoK(degF)));
    }

    private void handleCelsiusChange() {
        double degC = Double.valueOf(this._degCField.getText());
        DecimalFormat df = new DecimalFormat("#0.0");
        this._degFField.setText(df.format(this._modelAdapter.convertCtoF(degC)));
        this._kelvinField.setText(df.format(this._modelAdapter.convertCtoK(degC)));
    }

    private void handleKelvinChange() {
        double kelvin = Double.valueOf(this._kelvinField.getText());
        DecimalFormat df = new DecimalFormat("#0.0");
        this._degFField.setText(df.format(this._modelAdapter.convertKtoF(kelvin)));
        this._degCField.setText(df.format(this._modelAdapter.convertKtoC(kelvin)));
    }
}

