/*
 * Decompiled with CFR 0.152.
 */
package view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import model.IModelAdapter;

public class TempCalcView
extends JPanel {
    private JLabel _degFLabel;
    private JTextField _degCField;
    private IModelAdapter _modelAdapter;

    public TempCalcView(IModelAdapter modelAdapter) {
        this._modelAdapter = modelAdapter;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() {
        this.setSize(new Dimension(540, 380));
        this.setLayout(new BorderLayout());
        this._degCField = new JTextField("100.0");
        this._degCField.setPreferredSize(new Dimension(80, 30));
        this._degCField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TempCalcView.this.handleCelsiusChange();
            }
        });
        JPanel degCPanel = new JPanel();
        degCPanel.setLayout(new FlowLayout());
        degCPanel.add(new JLabel("C"));
        degCPanel.add(this._degCField);
        this._degFLabel = new JLabel("212.0");
        this._degFLabel.setPreferredSize(new Dimension(80, 30));
        JPanel degFPanel = new JPanel();
        degFPanel.setLayout(new FlowLayout());
        degFPanel.add(new JLabel("= F"));
        degFPanel.add(this._degFLabel);
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new FlowLayout());
        topPanel.add(degCPanel);
        topPanel.add(degFPanel);
        this.add((Component)topPanel, "Center");
        this.handleCelsiusChange();
    }

    private void handleCelsiusChange() {
        double degC = Double.valueOf(this._degCField.getText());
        DecimalFormat df = new DecimalFormat("#0.0");
        this._degFLabel.setText(df.format(this._modelAdapter.convertCtoF(degC)));
    }
}

